/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.utils.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class PermutationGenerator<E>
implements Iterable<List<E>> {
    private PermutationIterator<E> iterator;

    public PermutationGenerator(Collection<E> collection, int n) {
        this.iterator = new PermutationIterator<E>(collection, n);
    }

    @Override
    public Iterator<List<E>> iterator() {
        return this.iterator;
    }

    private class PermutationIterator<T>
    implements Iterator<List<T>> {
        private final List<T> collection;
        private boolean[] used;
        private int[] pointers;
        private final int length;
        private boolean actual;

        public PermutationIterator(Collection<T> collection, int n) {
            this.collection = new ArrayList<T>(collection);
            this.length = n;
            this.used = new boolean[this.collection.size()];
            this.pointers = this.generateInitPointer(new int[this.length], this.length);
            this.actual = true;
        }

        @Override
        public boolean hasNext() {
            for (int i = 0; i < this.length; ++i) {
                if (this.pointers[i] == this.collection.size() - i - 1) continue;
                return true;
            }
            return false;
        }

        @Override
        public List<T> next() {
            if (this.actual) {
                this.actual = false;
                return this.getList(this.pointers);
            }
            this.pointers = this.generateNextPointers(this.pointers);
            return this.getList(this.pointers);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private List<T> getList(int[] nArray) {
            ArrayList<T> arrayList = new ArrayList<T>(this.length);
            for (int i = 0; i < nArray.length; ++i) {
                arrayList.add(this.collection.get(nArray[i]));
            }
            return arrayList;
        }

        private int getNextUnused(int n) {
            for (int i = n + 1; i < this.used.length; ++i) {
                if (this.used[i]) continue;
                return i;
            }
            return -1;
        }

        private void changeUses(int n, int n2) {
            this.used[n] = false;
            this.used[n2] = true;
        }

        private int[] generateNextPointers(int[] nArray) {
            for (int i = nArray.length - 1; i >= 0; --i) {
                int n = this.getNextUnused(nArray[i]);
                if (n != -1) {
                    this.changeUses(nArray[i], n);
                    nArray[i] = n;
                    return this.generateInitPointer(nArray, nArray.length - i - 1);
                }
                this.used[nArray[i]] = false;
                nArray[i] = -1;
            }
            return null;
        }

        private int[] generateInitPointer(int[] nArray, int n) {
            for (int i = nArray.length - n; i < nArray.length; ++i) {
                int n2;
                nArray[i] = n2 = this.getNextUnused(-1);
                this.used[nArray[i]] = true;
            }
            return nArray;
        }
    }
}

