/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.utils.collections;

import gnu.trove.impl.PrimeFinder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class PackedStringCollection
implements Iterable<String> {
    protected static final int CAPACITY = 100000;
    protected static final int BUFFER_LENGTH = 1000000;
    protected static final double LOAD_FACTOR = 0.5;
    protected static final double REHASH_FACTOR = 1.35;
    private static final int NO_KEY = -1;
    private int capacity;
    private PackedStringArray stringArray;
    private int[] keys;
    private double loadFactor;
    private int maxCapacityToRehash;

    public PackedStringCollection(int n, int n2, double d) {
        this.loadFactor = d;
        this.stringArray = new PackedStringArray(n2);
        this.computeNewCapacity(n);
        this.fill();
        this.computeMaxCapacityToRehash();
    }

    public int getSize() {
        return this.stringArray.getSize();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getBufferLength() {
        return this.stringArray.getBufferLength();
    }

    public String getStringById(int n) {
        return this.stringArray.getStringById(n);
    }

    protected int put(String string) {
        this.rehashIfNeeded();
        int n = this.getIndexForInsertion(string);
        if (this.keys[n] == -1) {
            this.keys[n] = this.stringArray.appendToBuffer(string);
        }
        return n;
    }

    protected int getId(int n) {
        if (n < 0 || n >= this.capacity) {
            return -1;
        }
        return this.keys[n];
    }

    protected int getIndex(String string) {
        int n = string.hashCode() & Integer.MAX_VALUE;
        int n2 = n % this.capacity;
        if (this.keys[n2] == -1) {
            return -n2 - 1;
        }
        if (this.stringArray.equals(this.keys[n2], string)) {
            return n2;
        }
        int n3 = n % (this.capacity - 2) + 1;
        int n4 = 0;
        do {
            if ((n2 -= n3) >= 0) continue;
            n2 += this.capacity;
        } while (this.keys[n2] != -1 && !this.stringArray.equals(this.keys[n2], string) && ++n4 < this.capacity);
        return this.keys[n2] == -1 || n4 >= this.capacity ? -n2 - 1 : n2;
    }

    protected abstract void refillValues();

    protected abstract void copyValue(int var1, int var2);

    protected abstract void endRefillAndCopyValues();

    private void fill() {
        this.stringArray.refill(this.capacity);
        this.fillKeys();
    }

    private void refill() {
        this.stringArray.refill(this.capacity);
        this.fillKeys();
        this.refillValues();
    }

    private void fillKeys() {
        this.keys = new int[this.capacity];
        Arrays.fill(this.keys, -1);
    }

    private void computeNewCapacity(int n) {
        n = (int)((double)n / this.loadFactor);
        this.capacity = n = PrimeFinder.nextPrime((int)n);
    }

    private void computeMaxCapacityToRehash() {
        this.maxCapacityToRehash = Math.min(this.capacity - 1, (int)((double)this.capacity * this.loadFactor));
    }

    private int getIndexForInsertion(String string) {
        int n = this.getIndex(string);
        return n >= 0 ? n : -n - 1;
    }

    private void rehashIfNeeded() {
        int n = this.stringArray.getSize();
        if (n >= this.maxCapacityToRehash || n == this.capacity) {
            this.rehash((int)((double)this.capacity * 1.35));
        }
    }

    private void rehash(int n) {
        int[] nArray = this.keys;
        this.computeNewCapacity(n);
        this.refill();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == -1) continue;
            int n2 = this.getIndexForInsertion(this.getStringById(nArray[i]));
            this.keys[n2] = nArray[i];
            this.copyValue(i, n2);
        }
        this.endRefillAndCopyValues();
        this.computeMaxCapacityToRehash();
    }

    @Override
    public Iterator<String> iterator() {
        return new PackedStringCollectionIterator();
    }

    private class PackedStringCollectionIterator
    implements Iterator<String> {
        private int keyIndex = 0;

        public PackedStringCollectionIterator() {
            this.toNextIndex();
        }

        @Override
        public boolean hasNext() {
            return this.keyIndex < PackedStringCollection.this.keys.length;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String string = PackedStringCollection.this.getStringById(PackedStringCollection.this.keys[this.keyIndex]);
            ++this.keyIndex;
            this.toNextIndex();
            return string;
        }

        private void toNextIndex() {
            while (this.keyIndex < PackedStringCollection.this.keys.length && PackedStringCollection.this.keys[this.keyIndex] == -1) {
                ++this.keyIndex;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class PackedStringArray {
        private StringBuilder stringBuffer;
        private int[] stringOffsets;
        private int size;

        private PackedStringArray(int n) {
            this.stringBuffer = new StringBuilder(n);
            this.size = 0;
            this.stringOffsets = new int[this.size];
        }

        private int getSize() {
            return this.size;
        }

        private int getBufferLength() {
            return this.stringBuffer.length();
        }

        private void refill(int n) {
            this.stringOffsets = Arrays.copyOf(this.stringOffsets, n + 1);
        }

        private int appendToBuffer(String string) {
            if (this.size + 1 == this.stringOffsets.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            int n = this.size;
            this.stringOffsets[this.size] = this.stringBuffer.length();
            this.stringBuffer.append(string);
            ++this.size;
            this.stringOffsets[this.size] = this.stringBuffer.length();
            return n;
        }

        private String getStringById(int n) {
            if (n < 0 || n >= this.size) {
                return null;
            }
            return this.stringBuffer.substring(this.stringOffsets[n], this.stringOffsets[n + 1]);
        }

        private boolean equals(int n, String string) {
            if (n < 0 || n >= this.size) {
                return false;
            }
            int n2 = this.stringOffsets[n + 1] - this.stringOffsets[n];
            if (n2 != string.length()) {
                return false;
            }
            int n3 = this.stringOffsets[n];
            for (int i = 0; i < n2; ++i) {
                if (this.stringBuffer.charAt(n3 + i) == string.charAt(i)) continue;
                return false;
            }
            return true;
        }
    }
}

