/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.utils.collections;

import gnu.trove.impl.PrimeFinder;
import java.util.Arrays;

public class MapString2int {
    public static double DEFAULTFACTOR = 0.5;
    public static double REHASHFACTOR = 1.35;
    private final int FREE = -1;
    private final int EMPTY = 0;
    private final int maxLength;
    protected StringBuilder buffer;
    protected int[] offset;
    private int position;
    protected int[] keys;
    private int[] values;
    private double loadFactor;
    private int capacity;
    private int maxCapacityToRehash;
    private int size;

    public MapString2int(int n, int n2) {
        this(n, n2, DEFAULTFACTOR);
    }

    public MapString2int(int n, int n2, double d) {
        this.maxLength = n2;
        this.loadFactor = d;
        this.computeNewCapacity(n);
        this.size = 0;
        this.computeMaxCapacityToRehash();
        this.buffer = new StringBuilder(this.maxLength);
        this.offset = new int[this.capacity + 1];
        this.keys = new int[this.capacity];
        this.values = new int[this.capacity];
        this.position = 0;
        Arrays.fill(this.keys, -1);
        Arrays.fill(this.values, 0);
        Arrays.fill(this.offset, 0);
    }

    protected void computeMaxCapacityToRehash() {
        this.maxCapacityToRehash = Math.min(this.capacity - 1, (int)((double)this.capacity * this.loadFactor));
    }

    protected void computeNewCapacity(int n) {
        int n2 = (int)((double)n / this.loadFactor);
        this.capacity = n2 = PrimeFinder.nextPrime((int)n2);
    }

    protected int saveToBuffer(String string) {
        this.offset[this.position] = this.buffer.length();
        this.buffer.append(string);
        this.offset[this.position + 1] = this.buffer.length();
        int n = this.position++;
        return n;
    }

    public void put(String string, int n) {
        int n2 = this.getIndexForInsertion(string);
        if (this.keys[n2] == -1) {
            this.keys[n2] = this.saveToBuffer(string);
        }
        this.saveValue(n2, n);
        ++this.size;
        this.rehashIfNeeded();
    }

    protected void saveValue(int n, int n2) {
        this.values[n] = n2;
    }

    protected void rehashIfNeeded() {
        if (this.size >= this.maxCapacityToRehash || this.capacity - this.size == 0) {
            this.rehash((int)((double)this.capacity * REHASHFACTOR));
            this.computeMaxCapacityToRehash();
        }
    }

    protected void rehash(int n) {
        this.computeNewCapacity(n);
        int[] nArray = this.keys;
        int[] nArray2 = this.values;
        int[] nArray3 = this.offset;
        this.keys = new int[this.capacity];
        this.values = new int[this.capacity];
        this.offset = new int[this.capacity + 1];
        Arrays.fill(this.keys, -1);
        Arrays.fill(this.values, 0);
        Arrays.fill(this.offset, 0);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == -1) continue;
            int n2 = nArray[i];
            int n3 = this.getIndexForInsertion(this.buffer.substring(nArray3[n2], nArray3[n2 + 1]));
            this.keys[n3] = n2;
            this.values[n3] = nArray2[i];
            this.offset[n2] = nArray3[n2];
            this.offset[n2 + 1] = nArray3[n2 + 1];
        }
    }

    public int get(String string) {
        int n = this.getIndex(string);
        if (n < 0) {
            return 0;
        }
        return this.values[n];
    }

    protected int getIndexForInsertion(String string) {
        int n = this.keys.length;
        int n2 = string.hashCode() & Integer.MAX_VALUE;
        int n3 = n2 % n;
        if (this.keys[n3] == -1 || string.equals(this.buffer.substring(this.offset[this.keys[n3]], this.offset[this.keys[n3] + 1]))) {
            return n3;
        }
        int n4 = n2 % (n - 2) + 1;
        do {
            if ((n3 -= n4) >= 0) continue;
            n3 += n;
        } while (this.keys[n3] != -1 && !string.equals(this.buffer.substring(this.offset[this.keys[n3]], this.offset[this.keys[n3] + 1])));
        return n3;
    }

    protected int getIndex(String string) {
        int n = this.keys.length;
        int n2 = string.hashCode() & Integer.MAX_VALUE;
        int n3 = n2 % n;
        if (this.keys[n3] == -1) {
            return -1;
        }
        if (string.equals(this.buffer.substring(this.offset[this.keys[n3]], this.offset[this.keys[n3] + 1]))) {
            return n3;
        }
        int n4 = n2 % (n - 2) + 1;
        int n5 = 0;
        do {
            if ((n3 -= n4) >= 0) continue;
            n3 += n;
        } while (this.keys[n3] != -1 && !string.equals(this.buffer.substring(this.offset[this.keys[n3]], this.offset[this.keys[n3] + 1])) && ++n5 < this.keys.length);
        return this.keys[n3] == -1 || n5 >= this.keys.length ? -1 : n3;
    }

    public void finish() {
        this.buffer.trimToSize();
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getCurrentLength() {
        return this.buffer.length();
    }
}

