/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.utils.collections;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class AbstractChunkedIterator<T>
implements Iterator<List<T>> {
    private final Iterator<T> iterator;
    private List<T> chunk;
    private T head;

    public AbstractChunkedIterator(Iterator<T> iterator) {
        this.iterator = iterator;
        this.retrieveNextChunk();
    }

    @Override
    public boolean hasNext() {
        return this.chunk != null;
    }

    @Override
    public List<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        List<T> list = this.chunk;
        this.retrieveNextChunk();
        return list;
    }

    private void retrieveNextChunk() {
        if (this.head == null) {
            if (!this.iterator.hasNext()) {
                this.chunk = null;
                return;
            }
            this.head = this.iterator.next();
        }
        this.chunk = new ArrayList<T>();
        this.chunk.add(this.head);
        this.head = null;
        while (this.iterator.hasNext()) {
            T t = this.iterator.next();
            if (this.areInTheSameChunk(this.chunk.get(0), t)) {
                this.chunk.add(t);
                continue;
            }
            this.head = t;
            return;
        }
    }

    protected abstract boolean areInTheSameChunk(T var1, T var2);

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

