/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.utils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.concurrent.Semaphore;

public class RmiClientInvocationHandler
implements InvocationHandler {
    private final int numAttempts;
    private Remote stub = null;
    private Registry registry = null;
    private final String host;
    private final String name;
    private final int port;
    private ConnectionRecreator connectionRecreator;

    public RmiClientInvocationHandler(int n, String string, String string2, int n2) throws RemoteException {
        this.numAttempts = n;
        this.host = string2;
        this.name = string;
        this.port = n2;
        this.connectionRecreator = new ConnectionRecreator();
        this.connectionRecreator.recreateConnection();
    }

    protected void init() throws RemoteException {
        try {
            this.registry = LocateRegistry.getRegistry(this.host, this.port);
            this.stub = this.registry.lookup(this.name);
        }
        catch (NotBoundException notBoundException) {
            throw new RemoteException("Can't locate remote service with name " + this.name + " in RMI registry", notBoundException);
        }
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        try {
            for (int i = 0; i <= 2 * this.numAttempts; ++i) {
                try {
                    return method.invoke((Object)this.stub, objectArray);
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (!(invocationTargetException.getCause() instanceof RemoteException)) continue;
                    if (i == 2 * this.numAttempts) {
                        throw (RemoteException)invocationTargetException.getCause();
                    }
                    if (i != this.numAttempts - 1) continue;
                    this.connectionRecreator.recreateConnection();
                    continue;
                }
            }
            return method.invoke((Object)this.stub, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause() != null ? invocationTargetException.getCause() : invocationTargetException;
        }
    }

    class ConnectionRecreator {
        private boolean wait = false;
        private Semaphore sem = new Semaphore(1);
        Object lock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void recreateConnection() throws RemoteException {
            try {
                this.sem.acquire();
                if (this.wait) {
                    this.sem.release();
                    this.lock.wait();
                    return;
                }
                Object object = this.lock;
                synchronized (object) {
                    this.wait = true;
                    this.sem.release();
                    try {
                        RmiClientInvocationHandler.this.init();
                    }
                    catch (RemoteException remoteException) {
                        remoteException.printStackTrace();
                        throw remoteException;
                    }
                    finally {
                        boolean bl = false;
                        try {
                            this.sem.acquire();
                            bl = true;
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                            throw interruptedException;
                        }
                        finally {
                            this.wait = false;
                            this.lock.notifyAll();
                            if (bl) {
                                this.sem.release();
                            }
                        }
                    }
                    return;
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                throw new RemoteException("", interruptedException);
            }
        }
    }
}

