/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class ClasspathUtils {
    public static InputStream getResourceAsStream(String string, String string2) throws IOException {
        String string3 = ClasspathUtils.composeName(string, string2);
        return ClasspathUtils.getResourceAsStream(string3);
    }

    private static String composeName(String string, String string2) {
        int n = string.length();
        char c = string.charAt(n - 1);
        String string3 = ClasspathUtils.isSlashOrBackslash(c) ? string.substring(0, n - 1) : string;
        char c2 = string2.charAt(0);
        String string4 = ClasspathUtils.isSlashOrBackslash(c2) ? string2.substring(1) : string2;
        return string3 + "/" + string4;
    }

    private static boolean isSlashOrBackslash(char c) {
        return c == '\\' || c == '/';
    }

    public static InputStream getResourceAsStream(String string) throws IOException {
        ClassLoader classLoader = ClasspathUtils.getClassLoader();
        if (classLoader == null) {
            throw new IOException("Resource not found: " + string);
        }
        InputStream inputStream = classLoader.getResourceAsStream(string);
        if (inputStream == null) {
            throw new IOException("Resource not found: " + string);
        }
        return inputStream;
    }

    public static URL getResource(String string) {
        ClassLoader classLoader = ClasspathUtils.getClassLoader();
        return classLoader.getResource(string);
    }

    private static ClassLoader getClassLoader() {
        ClassLoader classLoader = ClasspathUtils.class.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }
}

