/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.texterra.restclient;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import ru.ispras.modis.texterra.TexterraException;

public abstract class ServletRequestDriver {
    private String texterraServletURLString;
    protected static final String ENCODING_USED = "UTF-8";

    protected ServletRequestDriver(String string, String string2, String string3) throws TexterraException {
        try {
            this.texterraServletURLString = string + "/" + string2 + "?lang=" + URLEncoder.encode(string3, ENCODING_USED);
        }
        catch (Exception exception) {
            throw new TexterraException(exception.getMessage());
        }
    }

    public InputStream annotateText(String string) throws TexterraException {
        try {
            DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
            HttpPost httpPost = new HttpPost(this.texterraServletURLString);
            httpPost.setEntity((HttpEntity)this.makeMultipartEntity(string));
            HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpPost);
            return httpResponse.getEntity().getContent();
        }
        catch (ConnectException connectException) {
            throw new TexterraException("Connection to Texterra Servlet was refused.");
        }
        catch (Exception exception) {
            throw new TexterraException(exception.getMessage());
        }
    }

    protected MultipartEntity makeMultipartEntity(String string) throws UnsupportedEncodingException {
        MultipartEntity multipartEntity = new MultipartEntity();
        StringBody stringBody = new StringBody(string, Charset.forName(ENCODING_USED));
        multipartEntity.addPart("text", (ContentBody)stringBody);
        return multipartEntity;
    }
}

