/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.modis.functional;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ru.ispras.modis.functional.SequenceFunction;

public class MapFlatten<T>
implements Iterable<T> {
    private final Iterable<T> subj;
    private final SequenceFunction<T> f;

    public MapFlatten(SequenceFunction<T> sequenceFunction, Iterable<T> iterable) {
        this.subj = iterable;
        this.f = sequenceFunction;
    }

    @Override
    public Iterator<T> iterator() {
        return new FlattenIterator(this.subj.iterator());
    }

    private class FlattenIterator
    implements Iterator<T> {
        private final Iterator<T> it;
        private final List<T> resultSet = new ArrayList();
        private Iterator<T> resultIterator;

        private void pullNext() {
            while (!this.resultIterator.hasNext() && this.it.hasNext()) {
                this.resultSet.clear();
                this.resultIterator = MapFlatten.this.f.transform(this.it.next(), this.resultSet).iterator();
            }
        }

        private FlattenIterator(Iterator<T> iterator) {
            this.it = iterator;
            this.resultIterator = this.resultSet.iterator();
        }

        @Override
        public boolean hasNext() {
            if (!this.resultIterator.hasNext()) {
                this.pullNext();
            }
            return this.resultIterator.hasNext();
        }

        @Override
        public T next() {
            if (!this.resultIterator.hasNext()) {
                this.pullNext();
            }
            return this.resultIterator.next();
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }
}

