/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.weka.regression;

import ru.ispras.ml.TrainingException;
import ru.ispras.ml.datamodel.IInstance;
import ru.ispras.ml.datamodel.ILabeledDataset;
import ru.ispras.ml.datamodel.ILabelledInstance;
import ru.ispras.ml.regression.IRegressor;
import ru.ispras.ml.regression.RegressionAlgorithmFacade;
import ru.ispras.ml.regression.RegressionException;
import ru.ispras.ml.regression.RegressionResult;
import ru.ispras.ml.weka.regression.WekaRegressorAdapter;
import ru.ispras.ml.weka.regression.WekaRegressorTrainer;

public class WekaMLBasedRegressor
implements RegressionAlgorithmFacade {
    private static final long serialVersionUID = -6429347083895505819L;
    private final WekaRegressorTrainer trainer;
    private WekaRegressorAdapter wekaAdapter;

    public WekaMLBasedRegressor(WekaRegressorTrainer trainer) {
        this.trainer = trainer;
    }

    @Override
    public RegressionResult predict(IInstance instance) throws RegressionException {
        if (this.wekaAdapter == null) {
            throw new IllegalStateException();
        }
        return this.wekaAdapter.predict(instance);
    }

    @Override
    public void train(ILabelledInstance<Double> precedent) throws TrainingException {
        this.trainer.train(precedent);
        this.wekaAdapter = (WekaRegressorAdapter)this.trainer.getWekaAdapter();
    }

    @Override
    public void train(ILabeledDataset<Double> data) throws TrainingException {
        this.trainer.train(data);
        this.wekaAdapter = (WekaRegressorAdapter)this.trainer.getWekaAdapter();
    }

    public IRegressor getPredictor() {
        return this.wekaAdapter;
    }
}

