/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.weka.classification;

import ru.ispras.ml.TrainingException;
import ru.ispras.ml.classification.ClassificationAlgorithmFacade;
import ru.ispras.ml.classification.ClassificationException;
import ru.ispras.ml.classification.ClassificationResult;
import ru.ispras.ml.classification.IClassifier;
import ru.ispras.ml.datamodel.IInstance;
import ru.ispras.ml.datamodel.ILabeledDataset;
import ru.ispras.ml.datamodel.ILabelledInstance;
import ru.ispras.ml.weka.AbstractWekaPredictorTrainer;
import ru.ispras.ml.weka.classification.WekaClassifierAdapter;
import ru.ispras.ml.weka.classification.WekaClassifierTrainer;

public class WekaMLBasedClassifier<LabelType>
implements ClassificationAlgorithmFacade<LabelType> {
    private static final long serialVersionUID = -134605351828189942L;
    private final WekaClassifierTrainer<LabelType> trainer;
    private WekaClassifierAdapter<LabelType> wekaAdapter;

    public WekaMLBasedClassifier(WekaClassifierTrainer trainer) {
        this.trainer = trainer;
    }

    @Override
    public ClassificationResult<LabelType> predict(IInstance instance) throws ClassificationException {
        if (this.wekaAdapter == null) {
            throw new IllegalStateException();
        }
        return this.wekaAdapter.predict(instance);
    }

    @Override
    public void train(ILabelledInstance<LabelType> precedent) throws TrainingException {
        ((AbstractWekaPredictorTrainer)this.trainer).train(precedent);
        this.wekaAdapter = (WekaClassifierAdapter)this.trainer.getWekaAdapter();
    }

    @Override
    public void train(ILabeledDataset<LabelType> precedents) throws TrainingException {
        this.trainer.train(precedents);
        this.wekaAdapter = (WekaClassifierAdapter)this.trainer.getWekaAdapter();
    }

    @Override
    public IClassifier<LabelType> getPredictor() {
        return this.wekaAdapter;
    }
}

