/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.weka.classification;

import java.util.List;
import ru.ispras.ml.classification.ClassificationException;
import ru.ispras.ml.classification.ClassificationResult;
import ru.ispras.ml.classification.IClassifier;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.IInstance;
import ru.ispras.ml.weka.AbstractWekaPredictorAdapter;
import ru.ispras.ml.weka.WekaAdapterUtils;
import weka.classifiers.Classifier;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class WekaClassifierAdapter<LabelType>
extends AbstractWekaPredictorAdapter
implements IClassifier<LabelType> {
    private static final long serialVersionUID = -8297961617789782549L;
    private final List<LabelType> orderedClasses;

    public WekaClassifierAdapter(Classifier wekaClassifier, FastVector wekaAttributes, Instances trainingSet, List<Feature> orderedFeatures, List<LabelType> orderedClasses) {
        super(wekaClassifier, wekaAttributes, trainingSet, orderedFeatures);
        this.orderedClasses = orderedClasses;
    }

    @Override
    public ClassificationResult<LabelType> predict(IInstance instance) throws ClassificationException {
        Instance wekaInstance = WekaAdapterUtils.toUnlabeledWekaInstance(instance, this.wekaAttributes, this.orderedFeatures);
        wekaInstance.setDataset(this.trainingSet);
        try {
            double wekaClassificationResult = this.wekaPredictor.classifyInstance(wekaInstance);
            return new ClassificationResult<LabelType>(this.orderedClasses.get((int)wekaClassificationResult));
        }
        catch (Exception e) {
            throw new ClassificationException(e);
        }
    }
}

