/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.weka;

import java.util.List;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.IInstance;
import ru.ispras.ml.datamodel.value.IValue;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;

public abstract class WekaAdapterUtils {
    public static Instance toUnlabeledWekaInstance(IInstance instance, FastVector wekaAttributes, List<Feature> orderedFeatures) {
        Instance wekaInstance = new Instance(wekaAttributes.size());
        for (int i = 0; i < wekaAttributes.size() - 1; ++i) {
            Double featureValue = WekaAdapterUtils.extractFeatureValue(instance.getFeatureValue(orderedFeatures.get(i)));
            wekaInstance.setValue((Attribute)wekaAttributes.elementAt(i), featureValue.doubleValue());
        }
        return wekaInstance;
    }

    private static Double extractFeatureValue(IValue featureValue) {
        if (featureValue.hasDouble()) {
            return featureValue.getDouble();
        }
        if (featureValue.hasInt()) {
            return featureValue.getInt();
        }
        if (featureValue.hasString()) {
            try {
                Double value = Double.valueOf(featureValue.getString());
                return value;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException();
    }
}

