/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.regression.linear.featurefunctions;

import ru.ispras.ml.regression.linear.featurefunctions.IFeatureFunction;

public class PolynomialFeatureFunction
implements IFeatureFunction {
    private static final long serialVersionUID = 5002332057616481030L;
    private final int power;

    public PolynomialFeatureFunction(int power) {
        if (power < 0) {
            throw new IllegalArgumentException("Negative 'power' is not permitted");
        }
        this.power = power;
    }

    @Override
    public double[] fn(double value) {
        double[] values = new double[this.power];
        for (int i = 0; i < this.power; ++i) {
            values[i] = Math.pow(value, i + 1);
        }
        return values;
    }

    public boolean equals(Object o) {
        if (o instanceof PolynomialFeatureFunction) {
            return ((PolynomialFeatureFunction)o).power == this.power;
        }
        return super.equals(o);
    }

    @Override
    public double compute(double value, double[] coefficients) {
        double result = 0.0;
        for (int i = 0; i < this.power; ++i) {
            result += coefficients[i] * Math.pow(value, i + 1);
        }
        return result;
    }

    @Override
    public int getCoefficientsNumber() {
        return this.power;
    }
}

