/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.regression.linear;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.regression.linear.InSampleQualityMetric;
import ru.ispras.ml.regression.linear.featurefunctions.IFeatureFunction;

public class LinearRegressorModel
implements Serializable {
    private static final long serialVersionUID = 2456844056620533167L;
    private Map<Feature, List<Double>> coefficients;
    private IFeatureFunction featureFunction;
    private double freeCoefficient;
    private InSampleQualityMetric qualityMetric;

    public LinearRegressorModel(Map<Feature, List<Double>> coefficients, double freeCoefficient, IFeatureFunction featureFunction, InSampleQualityMetric qualityMetric) {
        this.coefficients = coefficients;
        this.freeCoefficient = freeCoefficient;
        this.featureFunction = featureFunction;
        this.qualityMetric = qualityMetric;
    }

    public LinearRegressorModel(LinearRegressorModel model) {
        this(model.coefficients, model.freeCoefficient, model.featureFunction, model.qualityMetric);
    }

    public Map<Feature, List<Double>> getCoefficients() {
        return this.coefficients;
    }

    public IFeatureFunction getFeatureFunction() {
        return this.featureFunction;
    }

    public double getFreeCoefficient() {
        return this.freeCoefficient;
    }

    public double getRMSE() {
        return this.qualityMetric.getRmse();
    }

    public double getR2Coefficient() {
        return this.qualityMetric.getR2coefficient();
    }

    public boolean equals(Object o) {
        if (!(o instanceof LinearRegressorModel)) {
            return false;
        }
        LinearRegressorModel model = (LinearRegressorModel)o;
        return this.coefficients.equals(model.getCoefficients()) && this.freeCoefficient == model.freeCoefficient && this.qualityMetric.equals(model.qualityMetric) && this.featureFunction.equals(model.featureFunction);
    }
}

