/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.regression.linear;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.IInstance;
import ru.ispras.ml.datamodel.value.IValue;
import ru.ispras.ml.datamodel.value.cast.DoubleValueCaster;
import ru.ispras.ml.regression.IRegressor;
import ru.ispras.ml.regression.RegressionException;
import ru.ispras.ml.regression.RegressionResult;
import ru.ispras.ml.regression.linear.LinearRegressorModel;

public class LinearRegressor
implements IRegressor {
    private static final long serialVersionUID = 1208615474534536239L;
    private final LinearRegressorModel model;

    public LinearRegressor(LinearRegressorModel model) {
        this.model = model;
    }

    @Override
    public RegressionResult predict(IInstance instance) throws RegressionException {
        Map<Feature, IValue> featuresValues = instance.getFeaturesValues();
        double regressionResult = this.model.getFreeCoefficient();
        for (Map.Entry<Feature, IValue> featureValue : featuresValues.entrySet()) {
            Feature feature = featureValue.getKey();
            IValue value = featureValue.getValue();
            regressionResult += this.computeRegressionFunctionValue(feature, value);
        }
        return new RegressionResult(regressionResult);
    }

    private double computeRegressionFunctionValue(Feature feature, IValue value) throws RegressionException {
        double[] featureFunctionCoefficients;
        if (!this.model.getCoefficients().containsKey(feature)) {
            featureFunctionCoefficients = new double[this.model.getFeatureFunction().getCoefficientsNumber()];
            Arrays.fill(featureFunctionCoefficients, 0.0);
        } else {
            List<Double> featureFunctionCoefficientList = this.model.getCoefficients().get(feature);
            if (featureFunctionCoefficientList.size() != this.model.getFeatureFunction().getCoefficientsNumber()) {
                throw new RegressionException("Mismatch of model and instance: incorrect number of feature coefficients - " + feature);
            }
            featureFunctionCoefficients = ArrayUtils.toPrimitive((Double[])featureFunctionCoefficientList.toArray(new Double[featureFunctionCoefficientList.size()]));
        }
        double doubleFeatureValue = DoubleValueCaster.cast(value).getDouble();
        return this.model.getFeatureFunction().compute(doubleFeatureValue, featureFunctionCoefficients);
    }
}

