/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.regression.linear;

import ru.ispras.ml.TrainingException;
import ru.ispras.ml.datamodel.IInstance;
import ru.ispras.ml.datamodel.ILabeledDataset;
import ru.ispras.ml.datamodel.ILabelledInstance;
import ru.ispras.ml.regression.IRegressor;
import ru.ispras.ml.regression.RegressionAlgorithmFacade;
import ru.ispras.ml.regression.RegressionException;
import ru.ispras.ml.regression.RegressionResult;
import ru.ispras.ml.regression.linear.ILinearRegressorTrainer;
import ru.ispras.ml.regression.linear.LinearRegressor;

public class LinearMLBasedRegressor
implements RegressionAlgorithmFacade {
    private static final long serialVersionUID = 6848235266886348641L;
    private ILinearRegressorTrainer trainer;
    private IRegressor regressor;

    public LinearMLBasedRegressor(ILinearRegressorTrainer trainer) {
        this.trainer = trainer;
    }

    @Override
    public RegressionResult predict(IInstance instance) throws RegressionException {
        if (this.regressor == null) {
            throw new IllegalStateException("Regressor is null");
        }
        return this.regressor.predict(instance);
    }

    @Override
    public void train(ILabelledInstance<Double> precedent) throws TrainingException {
        this.trainer.train(precedent);
        this.regressor = new LinearRegressor(this.trainer.getModel());
    }

    @Override
    public void train(ILabeledDataset<Double> precedents) throws TrainingException {
        this.trainer.train(precedents);
        this.regressor = new LinearRegressor(this.trainer.getModel());
    }

    public IRegressor getPredictor() {
        return this.regressor;
    }
}

