/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.regression.linear;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.jet.math.Functions;
import java.io.Serializable;

public class InSampleQualityMetric
implements Serializable {
    private static final long serialVersionUID = 3565304811365653267L;
    private final double r2coefficient;
    private final double rmse;

    public InSampleQualityMetric(DoubleMatrix2D precedentsMatrix, DoubleMatrix1D coefficients, DoubleMatrix1D answersVector) {
        double sse = this.computeSSE(precedentsMatrix, coefficients, answersVector);
        this.r2coefficient = this.computeR2Coefficient(sse, answersVector);
        this.rmse = Math.sqrt(sse / (double)answersVector.size());
    }

    private double computeSSE(DoubleMatrix2D precedentsMatrix, DoubleMatrix1D coefficients, DoubleMatrix1D answers) {
        DoubleMatrix1D regressionAnswers = new Algebra().mult(precedentsMatrix, coefficients);
        regressionAnswers.assign(answers, Functions.minus);
        regressionAnswers.assign(Functions.pow((double)2.0));
        return regressionAnswers.zSum();
    }

    double computeR2Coefficient(double sse, DoubleMatrix1D answers) {
        DoubleMatrix1D answersCopy = answers.copy();
        double mean = answersCopy.zSum() / (double)answersCopy.size();
        answersCopy.assign(Functions.minus((double)mean));
        answersCopy.assign(Functions.pow((double)2.0));
        double ssTotal = answersCopy.zSum();
        return 1.0 - sse / ssTotal;
    }

    public double getR2coefficient() {
        return this.r2coefficient;
    }

    public double getRmse() {
        return this.rmse;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InSampleQualityMetric)) {
            return false;
        }
        InSampleQualityMetric castedObj = (InSampleQualityMetric)obj;
        return this.r2coefficient == castedObj.r2coefficient && this.rmse == castedObj.rmse;
    }
}

