/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.prediction.converted;

import java.util.stream.Stream;
import ru.ispras.ml.TrainingException;
import ru.ispras.ml.datamodel.ILabeledDataset;
import ru.ispras.ml.datamodel.ILabelledInstance;
import ru.ispras.ml.prediction.IPredictor;
import ru.ispras.ml.prediction.IPredictorTrainer;
import ru.ispras.ml.prediction.converted.ConvertedPredictor;
import ru.ispras.ml.prediction.converted.IInstanceConverter;

public final class ConvertedPredictorTrainer<LabelType>
implements IPredictorTrainer<LabelType> {
    private static final long serialVersionUID = -1658332720289862650L;
    private final IInstanceConverter instanceConverter;
    private final IPredictorTrainer<LabelType> wrapped;

    public ConvertedPredictorTrainer(IInstanceConverter instanceConverter, IPredictorTrainer<LabelType> wrapped) {
        this.instanceConverter = instanceConverter;
        this.wrapped = wrapped;
    }

    @Override
    public void train(ILabelledInstance<LabelType> precedent) throws TrainingException {
        ILabelledInstance<LabelType> biasedPrecedent = this.instanceConverter.convert(precedent);
        this.wrapped.train(biasedPrecedent);
    }

    @Override
    public void train(ILabeledDataset<LabelType> data) throws TrainingException {
        try (Stream stream = data.stream();){
            this.wrapped.train(() -> stream.map(precedent -> this.instanceConverter.convert(precedent)));
        }
    }

    @Override
    public IPredictor<LabelType> getPredictor() {
        return new ConvertedPredictor<LabelType>(this.instanceConverter, this.wrapped.getPredictor());
    }
}

