/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.liblinear.regression;

import de.bwaldvogel.liblinear.SolverType;
import ru.ispras.ml.TrainingException;
import ru.ispras.ml.datamodel.ILabeledDataset;
import ru.ispras.ml.datamodel.ILabelledInstance;
import ru.ispras.ml.liblinear.AbstractLibLinearTrainer;
import ru.ispras.ml.liblinear.LibLinearModel;
import ru.ispras.ml.liblinear.regression.LibLinearRegressor;

public class LibLinearRegressorTrainer
extends AbstractLibLinearTrainer<Double, LibLinearModel> {
    private static final long serialVersionUID = 8967587347899508537L;

    public LibLinearRegressorTrainer(SolverType solverType, double c, double eps) {
        super(solverType, c, eps);
        if (!solverType.isSupportVectorRegression()) {
            throw new IllegalArgumentException("Provided solver type " + solverType + " does not support regression!");
        }
    }

    @Override
    public void train(ILabeledDataset<Double> dataset) throws TrainingException {
        this.model = this.trainLibLinear(dataset, new RegressionToLibLinearLabelledInstanceConverter());
    }

    @Override
    public void train(ILabelledInstance<Double> precedent) throws TrainingException {
        throw new UnsupportedOperationException();
    }

    public LibLinearRegressor getPredictor() {
        return new LibLinearRegressor(this.model);
    }

    private static final class RegressionToLibLinearLabelledInstanceConverter
    extends AbstractLibLinearTrainer.ToLibLinearLabelledInstanceConverter<Double> {
        private RegressionToLibLinearLabelledInstanceConverter() {
        }

        @Override
        protected double convertLabel(Double label) {
            return label;
        }
    }
}

