/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.liblinear.classification;

import de.bwaldvogel.liblinear.SolverType;
import java.util.HashMap;
import java.util.Map;
import ru.ispras.ml.TrainingException;
import ru.ispras.ml.classification.IConfidenceClassifierTrainer;
import ru.ispras.ml.datamodel.ILabeledDataset;
import ru.ispras.ml.datamodel.ILabelledInstance;
import ru.ispras.ml.liblinear.AbstractLibLinearTrainer;
import ru.ispras.ml.liblinear.classification.LibLinearClassifierModel;
import ru.ispras.ml.liblinear.classification.LibLinearConfidenceClassifier;

public class LibLinearClassifierTrainer<LabelType>
extends AbstractLibLinearTrainer<LabelType, LibLinearClassifierModel<LabelType>>
implements IConfidenceClassifierTrainer<LabelType> {
    private static final long serialVersionUID = 242248384650889855L;

    public LibLinearClassifierTrainer(SolverType solverType, double c, double eps) {
        super(solverType, c, eps);
        if (solverType.isSupportVectorRegression()) {
            throw new IllegalArgumentException("Provided solver type " + solverType + " does not support classification!");
        }
    }

    @Override
    public void train(ILabeledDataset<LabelType> precedents) throws TrainingException {
        ClassificationToLibLinearLabelledInstanceConverter instanceConverter = new ClassificationToLibLinearLabelledInstanceConverter();
        this.model = new LibLinearClassifierModel(this.trainLibLinear(precedents, instanceConverter), instanceConverter.getIndicesToClasses());
    }

    @Override
    public void train(ILabelledInstance<LabelType> precedent) throws TrainingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public LibLinearConfidenceClassifier<LabelType> getPredictor() {
        return new LibLinearConfidenceClassifier((LibLinearClassifierModel)this.model);
    }

    private static final class ClassificationToLibLinearLabelledInstanceConverter<LabelType>
    extends AbstractLibLinearTrainer.ToLibLinearLabelledInstanceConverter<LabelType> {
        private final Map<LabelType, Integer> classesToIndices = new HashMap<LabelType, Integer>();
        private final Map<Integer, LabelType> indicesToClasses = new HashMap<Integer, LabelType>();

        private ClassificationToLibLinearLabelledInstanceConverter() {
        }

        @Override
        protected synchronized double convertLabel(LabelType label) {
            return this.getOrAllocateIndexForClass(label, this.classesToIndices, this.indicesToClasses);
        }

        private int getOrAllocateIndexForClass(LabelType classId, Map<LabelType, Integer> classesToIndices, Map<Integer, LabelType> indicesToClasses) {
            int result;
            if (classesToIndices.containsKey(classId)) {
                result = classesToIndices.get(classId);
            } else {
                result = classesToIndices.size();
                classesToIndices.put(classId, result);
                indicesToClasses.put(result, classId);
            }
            return result;
        }

        public Map<Integer, LabelType> getIndicesToClasses() {
            return this.indicesToClasses;
        }
    }
}

