/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.liblinear;

import de.bwaldvogel.liblinear.FeatureNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.IInstance;
import ru.ispras.ml.datamodel.value.IValue;

public class LibLinearFeatureExtractionHelper {
    public static Map<Feature, Integer> getFeaturesOrder(List<? extends IInstance> instances) {
        HashMap<Feature, Integer> result = new HashMap<Feature, Integer>();
        for (IInstance iInstance : instances) {
            LibLinearFeatureExtractionHelper.updateFeaturesOrder(iInstance, result);
        }
        return result;
    }

    public static void updateFeaturesOrder(IInstance instance, Map<Feature, Integer> featuresOrder) {
        for (Feature feature : instance.getFeaturesValues().keySet()) {
            if (featuresOrder.containsKey(feature)) continue;
            featuresOrder.put(feature, featuresOrder.size() + 1);
        }
    }

    public static List<FeatureNode[]> extractLibLinearFeatures(List<? extends IInstance> instances, Map<Feature, Integer> featuresOrder) {
        ArrayList<FeatureNode[]> result = new ArrayList<FeatureNode[]>(instances.size());
        for (IInstance iInstance : instances) {
            result.add(LibLinearFeatureExtractionHelper.extractLibLinearFeatures(iInstance, featuresOrder));
        }
        return result;
    }

    public static FeatureNode[] extractLibLinearFeatures(IInstance instance, Map<Feature, Integer> featuresOrder) {
        ArrayList<FeatureNode> result = new ArrayList<FeatureNode>();
        for (Map.Entry<Feature, IValue> featureAndValue : instance.getFeaturesValues().entrySet()) {
            Integer order = featuresOrder.get(featureAndValue.getKey());
            if (order == null) continue;
            result.add(new FeatureNode(order.intValue(), LibLinearFeatureExtractionHelper.extractFeatureValue(featureAndValue.getValue())));
        }
        return LibLinearFeatureExtractionHelper.sort(result);
    }

    private static FeatureNode[] sort(List<FeatureNode> featureNodes) {
        FeatureNode[] result = featureNodes.toArray(new FeatureNode[featureNodes.size()]);
        Arrays.sort(result, new Comparator<FeatureNode>(){

            @Override
            public int compare(FeatureNode o1, FeatureNode o2) {
                return Integer.compare(o1.getIndex(), o2.getIndex());
            }
        });
        return result;
    }

    public static double extractFeatureValue(IValue featureValue) {
        double value;
        if (featureValue.hasDouble()) {
            value = featureValue.getDouble();
        } else if (featureValue.hasInt()) {
            value = featureValue.getInt();
        } else if (featureValue.hasBoolean()) {
            value = featureValue.getBoolean() ? 1.0 : 0.0;
        } else {
            throw new IllegalArgumentException("Double, integer and boolean features are supported only.");
        }
        return value;
    }
}

