/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.liblinear;

import de.bwaldvogel.liblinear.FeatureNode;
import de.bwaldvogel.liblinear.Linear;
import de.bwaldvogel.liblinear.Model;
import de.bwaldvogel.liblinear.Parameter;
import de.bwaldvogel.liblinear.Problem;
import de.bwaldvogel.liblinear.SolverType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.Validate;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.ILabeledDataset;
import ru.ispras.ml.datamodel.ILabelledInstance;
import ru.ispras.ml.liblinear.LibLinearFeatureExtractionHelper;
import ru.ispras.ml.liblinear.LibLinearModel;
import ru.ispras.ml.prediction.IPredictorTrainer;

public abstract class AbstractLibLinearTrainer<LabelType, ModelType extends LibLinearModel>
implements IPredictorTrainer<LabelType> {
    private static final long serialVersionUID = -5084052203116417839L;
    private static final Object lock = new Object();
    private static final double bias = -1.0;
    private final SolverType solverType;
    private final double c;
    private final double eps;
    protected ModelType model;

    public AbstractLibLinearTrainer(SolverType solverType, double c, double eps) {
        this.solverType = solverType;
        this.c = c;
        this.eps = eps;
    }

    public ModelType getModel() {
        return this.model;
    }

    public SolverType getSolverType() {
        return this.solverType;
    }

    protected LibLinearModel trainLibLinear(ILabeledDataset<LabelType> data, ToLibLinearLabelledInstanceConverter<LabelType> instanceConverter) {
        try (Stream stream = data.stream();){
            List<LibLinearLabelledInstance> precedentsAnswers = stream.map(instance -> instanceConverter.convert((ILabelledInstance)instance)).collect(Collectors.toList());
            Validate.isTrue((precedentsAnswers.size() > 0 ? 1 : 0) != 0, (String)"Predecents list should contain at least one element.");
            Map<Feature, Integer> featuresOrder = instanceConverter.getFeaturesOrder();
            int featuresNumber = featuresOrder.size();
            Problem problem = this.constructLibLinearProblem(precedentsAnswers, featuresNumber);
            Linear.disableDebugOutput();
            LibLinearModel libLinearModel = new LibLinearModel(this.trainThreadSafely(problem), featuresOrder);
            return libLinearModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Model trainThreadSafely(Problem problem) {
        Object object = lock;
        synchronized (object) {
            Linear.resetRandom();
            return Linear.train((Problem)problem, (Parameter)new Parameter(this.solverType, this.c, this.eps));
        }
    }

    private Problem constructLibLinearProblem(List<LibLinearLabelledInstance> precedentsAnswers, int featuresNumber) {
        Problem problem = new Problem();
        problem.bias = -1.0;
        problem.n = featuresNumber;
        problem.l = precedentsAnswers.size();
        problem.x = new FeatureNode[problem.l][];
        problem.y = new double[problem.l];
        for (int i = 0; i < problem.l; ++i) {
            problem.x[i] = precedentsAnswers.get(i).getFeatures();
            problem.y[i] = precedentsAnswers.get(i).getLabel();
        }
        return problem;
    }

    protected static abstract class ToLibLinearLabelledInstanceConverter<Label> {
        private final Map<Feature, Integer> featuresOrder = new HashMap<Feature, Integer>();

        protected ToLibLinearLabelledInstanceConverter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final LibLinearLabelledInstance convert(ILabelledInstance<Label> instance) {
            Map<Feature, Integer> map = this.featuresOrder;
            synchronized (map) {
                LibLinearFeatureExtractionHelper.updateFeaturesOrder(instance, this.featuresOrder);
                return new LibLinearLabelledInstance(LibLinearFeatureExtractionHelper.extractLibLinearFeatures(instance, this.featuresOrder), this.convertLabel(instance.getLabel()));
            }
        }

        public Map<Feature, Integer> getFeaturesOrder() {
            return this.featuresOrder;
        }

        protected abstract double convertLabel(Label var1);
    }

    protected static final class LibLinearLabelledInstance {
        private final FeatureNode[] features;
        private final double label;

        public LibLinearLabelledInstance(FeatureNode[] features, double label) {
            this.features = features;
            this.label = label;
        }

        public FeatureNode[] getFeatures() {
            return this.features;
        }

        public double getLabel() {
            return this.label;
        }
    }
}

