/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.featureselectors.filters;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.featureselectors.IFeatureFilter;
import ru.ispras.modis.utils.collections.MapUtils;

public class TopWeighedFeatureFilter
implements IFeatureFilter {
    private final int maxCount;

    public TopWeighedFeatureFilter(int maxCount) {
        if (maxCount < 0) {
            throw new IllegalArgumentException();
        }
        this.maxCount = maxCount;
    }

    @Override
    public Set<Feature> filter(Map<Feature, Double> feature2weight) {
        List sortedFeatures = MapUtils.getSortedByValueKeys(feature2weight);
        return new HashSet<Feature>(sortedFeatures.subList(Math.max(0, sortedFeatures.size() - this.maxCount), sortedFeatures.size()));
    }
}

