/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.featureselectors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.ILabeledDataset;
import ru.ispras.ml.featureselectors.IFeatureFilter;
import ru.ispras.ml.featureselectors.IFeatureSelector;
import ru.ispras.ml.featureselectors.IFeatureWeighter;

public final class WeightingFeatureSelector<LabelType>
implements IFeatureSelector<LabelType> {
    private final IFeatureWeighter<LabelType> weighter;
    private final IFeatureFilter filter;

    public WeightingFeatureSelector(IFeatureWeighter<LabelType> weighter, IFeatureFilter filter) {
        this.weighter = weighter;
        this.filter = filter;
    }

    public static List<Map.Entry<Feature, Double>> sort(Map<Feature, Double> feature2Value) {
        ArrayList<Map.Entry<Feature, Double>> list = new ArrayList<Map.Entry<Feature, Double>>(feature2Value.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Feature, Double>>(){

            @Override
            public int compare(Map.Entry<Feature, Double> e1, Map.Entry<Feature, Double> e2) {
                return Double.compare(e1.getValue(), e2.getValue());
            }
        });
        return list;
    }

    @Override
    public Set<Feature> select(ILabeledDataset<LabelType> dataset) {
        Map<Feature, Double> feature2weight = this.weighter.weight(dataset);
        Set<Feature> filtered = this.filter.filter(feature2weight);
        return filtered;
    }
}

