/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.featureselectors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.ILabeledDataset;
import ru.ispras.ml.featureselectors.IFeatureSelector;

public final class IntersectFeatureSelector<LabelType>
implements IFeatureSelector<LabelType> {
    private final Collection<IFeatureSelector<LabelType>> featureSelectors;

    public IntersectFeatureSelector(Collection<IFeatureSelector<LabelType>> featureSelectors) {
        this.featureSelectors = new ArrayList<IFeatureSelector<LabelType>>(featureSelectors);
    }

    @SafeVarargs
    public IntersectFeatureSelector(IFeatureSelector<LabelType> ... featureSelectors) {
        this(Arrays.asList(featureSelectors));
    }

    @Override
    public Set<Feature> select(ILabeledDataset<LabelType> dataset) {
        return this.featureSelectors.stream().map(selector -> selector.select(dataset)).reduce((a, b) -> {
            HashSet result = new HashSet(a);
            result.retainAll((Collection<?>)b);
            return result;
        }).get();
    }
}

