/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.featureextractors;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections15.Predicate;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.value.BooleanValue;
import ru.ispras.ml.datamodel.value.IValue;
import ru.ispras.ml.datamodel.value.Type;
import ru.ispras.ml.featureextractors.IFeatureExtractor;

public class PredicateFeatureExtractor<RawDataType>
implements IFeatureExtractor<RawDataType> {
    private static final long serialVersionUID = -6891447954287995963L;
    private final Feature feature;
    private final Predicate<RawDataType> predicate;

    public PredicateFeatureExtractor(Predicate<RawDataType> predicate, String booleanFeatureName) {
        this.predicate = predicate;
        this.feature = new Feature(booleanFeatureName, Type.BOOLEAN);
    }

    @Override
    public Map<Feature, IValue> extract(RawDataType rawData) {
        boolean eval = this.predicate.evaluate(rawData);
        return Collections.singletonMap(this.feature, BooleanValue.of(eval));
    }
}

