/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.datamodel.value;

import java.util.HashMap;
import java.util.Map;
import ru.ispras.ml.datamodel.value.AbstractValue;
import ru.ispras.ml.datamodel.value.BooleanValue;
import ru.ispras.ml.datamodel.value.DoubleValue;
import ru.ispras.ml.datamodel.value.IValue;
import ru.ispras.ml.datamodel.value.IntValue;
import ru.ispras.ml.datamodel.value.StringValue;
import ru.ispras.ml.datamodel.value.Type;
import ru.ispras.ml.datamodel.value.cast.ValueCastException;

public class ValueFactory {
    private static final IValueCreator intParser = new IValueCreator(){

        @Override
        public Type getType() {
            return Type.INTEGER;
        }

        @Override
        public IValue createValue(String s) {
            return new IntValue(Integer.parseInt(s));
        }
    };
    private static final IValueCreator doubleParser = new IValueCreator(){

        @Override
        public Type getType() {
            return Type.DOUBLE;
        }

        @Override
        public IValue createValue(String s) {
            return new DoubleValue(Double.parseDouble(s));
        }
    };
    private static final IValueCreator stringParser = new IValueCreator(){

        @Override
        public Type getType() {
            return Type.STRING;
        }

        @Override
        public IValue createValue(String s) {
            return new StringValue(s);
        }
    };
    private static final IValueCreator booleanParser = new IValueCreator(){

        @Override
        public Type getType() {
            return Type.BOOLEAN;
        }

        @Override
        public IValue createValue(String s) {
            if (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("t") || s.equals("1")) {
                return BooleanValue.TRUE;
            }
            if (s.equalsIgnoreCase("false") || s.equalsIgnoreCase("f") || s.equals("0")) {
                return BooleanValue.FALSE;
            }
            throw new IllegalArgumentException(String.format("\"%s\" is incorrect for boolean type", s));
        }
    };
    private static Map<Type, IValueCreator> map = new HashMap<Type, IValueCreator>();

    public static <T> IValue makeIValue(T value) {
        AbstractValue result;
        if (value instanceof Boolean) {
            result = BooleanValue.of((Boolean)value);
        } else if (value instanceof Integer) {
            result = new IntValue((Integer)value);
        } else if (value instanceof Double) {
            result = new DoubleValue((Double)value);
        } else if (value instanceof String) {
            result = new StringValue((String)value);
        } else {
            throw new ValueCastException(String.format("Unsupported input type: %s", value.getClass()));
        }
        return result;
    }

    public static IValue parseToValue(String string) {
        try {
            int i = Integer.parseInt(string);
            return new IntValue(i);
        }
        catch (NumberFormatException notIntegerException) {
            try {
                double d = Double.parseDouble(string);
                return new DoubleValue(d);
            }
            catch (NumberFormatException notDoubleException) {
                return new StringValue(string);
            }
        }
    }

    public static IValue parseToValue(String string, Type type) {
        try {
            return map.get((Object)type).createValue(string);
        }
        catch (Exception e) {
            throw new ValueCastException(e);
        }
    }

    public static boolean isTypeSupported(Type type) {
        return map.containsKey((Object)type);
    }

    static {
        map.put(Type.INTEGER, intParser);
        map.put(Type.STRING, stringParser);
        map.put(Type.DOUBLE, doubleParser);
        map.put(Type.BOOLEAN, booleanParser);
    }

    private static interface IValueCreator {
        public Type getType();

        public IValue createValue(String var1);
    }
}

