/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.datamodel.value;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import ru.ispras.ml.datamodel.value.AbstractValue;
import ru.ispras.ml.datamodel.value.IValue;
import ru.ispras.ml.datamodel.value.Type;

public class DoubleValue
extends AbstractValue {
    private static final long serialVersionUID = 8892046016145191637L;
    private static final NumberFormat decimalFormat = DecimalFormat.getInstance();
    private double data;

    public DoubleValue(double data) {
        this.data = data;
    }

    @Override
    public boolean hasDouble() {
        return true;
    }

    @Override
    public double getDouble() {
        return this.data;
    }

    public String toString() {
        return decimalFormat.format(this.data);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IValue && ((IValue)obj).hasDouble()) {
            return Double.compare(((IValue)obj).getDouble(), this.data) == 0;
        }
        return false;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.getDouble());
        return (int)(bits ^ bits >>> 32);
    }

    @Override
    public Type getFeatureType() {
        return Type.DOUBLE;
    }

    static {
        decimalFormat.setGroupingUsed(false);
        decimalFormat.setMinimumFractionDigits(0);
    }
}

