/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.datamodel;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ru.ispras.ml.datamodel.ILabeledDataset;
import ru.ispras.ml.datamodel.ILabelledInstance;

public class ListLabelledDataset<LabelType>
implements ILabeledDataset<LabelType> {
    private final List<ILabelledInstance<LabelType>> list;

    public ListLabelledDataset(List<ILabelledInstance<LabelType>> data) {
        this.list = ImmutableList.copyOf(data);
    }

    public ListLabelledDataset(Iterable<ILabelledInstance<LabelType>> data) {
        this.list = ImmutableList.copyOf(data);
    }

    public ListLabelledDataset(ILabeledDataset<LabelType> data) {
        try (Stream stream = data.stream();){
            this.list = ImmutableList.copyOf((Collection)stream.collect(Collectors.toList()));
        }
    }

    public List<ILabelledInstance<LabelType>> getList() {
        return this.list;
    }

    @Override
    public Stream<ILabelledInstance<LabelType>> stream() {
        return this.list.stream();
    }
}

