/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.datamodel;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.IInstance;
import ru.ispras.ml.datamodel.Instance;
import ru.ispras.ml.datamodel.identification.IInstanceId;
import ru.ispras.ml.datamodel.identification.InstanceIdGeneratingStrategy;
import ru.ispras.ml.datamodel.value.IValue;
import ru.ispras.ml.featureextractors.IFeatureExtractor;

public class InstanceFactory<SourceDataType>
implements Serializable {
    private static final long serialVersionUID = 1603873679790343378L;
    private final List<IFeatureExtractor<SourceDataType>> featureExtractors;
    private final InstanceIdGeneratingStrategy<SourceDataType> instanceIdGeneratingStrategy;

    public InstanceFactory(List<IFeatureExtractor<SourceDataType>> featureExtractors, InstanceIdGeneratingStrategy<SourceDataType> instanceIdGeneratingStrategy) {
        this.featureExtractors = featureExtractors;
        this.instanceIdGeneratingStrategy = instanceIdGeneratingStrategy;
    }

    public IInstance createInstance(SourceDataType rawData) {
        HashMap<Feature, IValue> features = new HashMap<Feature, IValue>();
        for (int featureExtractorIndex = 0; featureExtractorIndex < this.featureExtractors.size(); ++featureExtractorIndex) {
            Map<Feature, IValue> extractedFeatures = this.featureExtractors.get(featureExtractorIndex).extract(rawData);
            for (Map.Entry<Feature, IValue> feature2Value : extractedFeatures.entrySet()) {
                Feature feature = feature2Value.getKey();
                IValue value = feature2Value.getValue();
                Feature newFeature = new Feature("" + featureExtractorIndex + " " + feature.getName(), feature.getType());
                features.put(newFeature, value);
            }
        }
        IInstanceId id = this.instanceIdGeneratingStrategy.generate(rawData);
        return new Instance(id, features);
    }
}

