/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.datamodel;

import java.io.Serializable;
import java.util.Objects;
import ru.ispras.ml.datamodel.value.Type;

public final class Feature
implements Serializable {
    private static final long serialVersionUID = -6462045833067402142L;
    private final String name;
    private final Type type;

    public Feature(String name, Type type) {
        this.name = Objects.requireNonNull(name, "Feature name should not be null");
        this.type = Objects.requireNonNull(type, "Feature type should not be null");
    }

    public Feature(String name) {
        this(name, Type.ANY);
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Feature other = (Feature)obj;
        return this.name.equals(other.name) && this.type == other.type;
    }

    public String toString() {
        return "Feature[" + this.name + ", " + this.type.toString() + "]";
    }
}

