/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.classification.randomforest;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import quickml.data.AttributesMap;
import quickml.data.PredictionMap;
import quickml.supervised.ensembles.randomForest.randomDecisionForest.RandomDecisionForest;
import ru.ispras.ml.classification.ClassificationException;
import ru.ispras.ml.classification.ConfidenceClassificationResult;
import ru.ispras.ml.classification.IConfidenceClassifier;
import ru.ispras.ml.classification.randomforest.AttributesMapHelper;
import ru.ispras.ml.datamodel.IInstance;

public final class RandomForestClassifier<L extends Serializable>
implements IConfidenceClassifier<L> {
    private static final long serialVersionUID = 3369483542135791601L;
    private final RandomDecisionForest randomForestModel;

    public RandomForestClassifier(RandomDecisionForest randomForestModel) {
        this.randomForestModel = randomForestModel;
    }

    @Override
    public ConfidenceClassificationResult<L> predict(IInstance instance) throws ClassificationException {
        AttributesMap attributes = AttributesMapHelper.getAttributes(instance);
        PredictionMap result = this.randomForestModel.predict(attributes);
        Map.Entry max = result.entrySet().stream().max(Comparator.comparing(Map.Entry::getValue)).get();
        return new ConfidenceClassificationResult<Serializable>((Serializable)max.getKey(), (Double)max.getValue());
    }
}

