/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.classification.passiveaggressive.trainers;

import org.apache.commons.lang.Validate;
import ru.ispras.ml.classification.passiveaggressive.models.IPAModel;
import ru.ispras.ml.classification.passiveaggressive.trainers.AbstractPATrainer;

public class SoftMarginPATrainerII<LabelType>
extends AbstractPATrainer<LabelType> {
    private static final long serialVersionUID = 6996936174295125557L;
    private final double C;

    public SoftMarginPATrainerII(IPAModel<LabelType> model, double C) {
        super(model);
        Validate.isTrue((C > 0.0 ? 1 : 0) != 0, (String)"aggressiveness parameter should be greater than 0");
        this.C = C;
    }

    public SoftMarginPATrainerII(IPAModel<LabelType> model, double margin, double C) {
        super(model, margin);
        Validate.isTrue((C > 0.0 ? 1 : 0) != 0, (String)"aggressiveness parameter should be greater than 0");
        this.C = C;
    }

    @Override
    protected double getUpdateCoefficient(double loss, double squaredNorm) {
        return loss / (squaredNorm + 0.5 / this.C);
    }
}

