/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.classification.passiveaggressive.kernels;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import ru.ispras.ml.classification.passiveaggressive.kernels.AbstractKernel;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.IInstance;
import ru.ispras.ml.datamodel.value.IValue;
import ru.ispras.ml.datamodel.value.cast.DoubleValueCaster;

public class RBFKernel
extends AbstractKernel {
    private static final long serialVersionUID = 385500427980936681L;
    private static final double DEFAULT_BANDWIDTH = 1.0;
    private final double bandwidth;

    public RBFKernel() {
        this.bandwidth = 1.0;
    }

    public RBFKernel(double bandwidth) {
        Validate.isTrue((bandwidth != 0.0 ? 1 : 0) != 0, (String)"Bandwidth parameter should not be equal 0");
        this.bandwidth = bandwidth;
    }

    @Override
    public double innerProduct(IInstance x, IInstance y) {
        double squaredEuDist = 0.0;
        Set<Feature> xFeatures = x.getFeaturesValues().keySet();
        for (Feature feature : xFeatures) {
            IValue xv = x.getFeatureValue(feature);
            double diff = DoubleValueCaster.cast(xv).getDouble();
            if (y.hasFeature(feature)) {
                IValue yv = y.getFeatureValue(feature);
                diff -= DoubleValueCaster.cast(yv).getDouble();
            }
            squaredEuDist += diff * diff;
        }
        HashSet<Feature> yFeaturesNotInX = new HashSet<Feature>(y.getFeaturesValues().keySet());
        yFeaturesNotInX.removeAll(xFeatures);
        for (Feature feature : yFeaturesNotInX) {
            IValue yv = y.getFeatureValue(feature);
            double diff = DoubleValueCaster.cast(yv).getDouble();
            squaredEuDist += diff * diff;
        }
        return Math.exp(-squaredEuDist / (2.0 * this.bandwidth * this.bandwidth));
    }

    @Override
    public double innerProduct(IInstance x) {
        return 1.0;
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        return this.bandwidth == ((RBFKernel)other).bandwidth;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ new Double(this.bandwidth).hashCode();
    }
}

