/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.classification.passiveaggressive;

import org.apache.commons.lang.Validate;
import ru.ispras.ml.classification.ClassificationException;
import ru.ispras.ml.classification.ClassificationResult;
import ru.ispras.ml.classification.IClassifier;
import ru.ispras.ml.classification.passiveaggressive.models.IPAModel;
import ru.ispras.ml.datamodel.IInstance;
import ru.ispras.ml.datamodel.value.IValue;
import ru.ispras.ml.datamodel.value.cast.DoubleValueCaster;

public class PAClassifier<LabelType>
implements IClassifier<LabelType> {
    private static final long serialVersionUID = 4000040619792895433L;
    private static final double DEFAULT_MARGIN = 0.0;
    private final double margin;
    private final IPAModel<LabelType> model;

    public PAClassifier(IPAModel<LabelType> model) {
        this(model, 0.0);
    }

    public PAClassifier(IPAModel<LabelType> model, double margin) {
        Validate.notNull(model, (String)"Model should not be null");
        Validate.isTrue((margin >= 0.0 ? 1 : 0) != 0, (String)"Margin should be greater than zero");
        this.model = model;
        this.margin = margin;
    }

    @Override
    public ClassificationResult<LabelType> predict(IInstance instance) throws ClassificationException {
        Validate.notNull((Object)instance, (String)"Instance should not be null");
        for (IValue value : instance.getFeaturesValues().values()) {
            Validate.isTrue((boolean)DoubleValueCaster.canCast(value), (String)"It should be possible to cast all features to double");
        }
        double instanceMargin = this.model.getMarginOn(instance);
        if (instanceMargin > this.margin) {
            return new ClassificationResult<LabelType>(this.model.getPositiveLabel());
        }
        if (instanceMargin < -this.margin) {
            return new ClassificationResult<LabelType>(this.model.getNegativeLabel());
        }
        throw new ClassificationException("Can't determine class label for instance");
    }
}

