/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.classification.passiveaggressive;

import ru.ispras.ml.classification.passiveaggressive.PassiveAggressive;
import ru.ispras.ml.classification.passiveaggressive.kernels.IKernelFunction;
import ru.ispras.ml.classification.passiveaggressive.models.IPAModel;
import ru.ispras.ml.classification.passiveaggressive.models.LinearPAModel;
import ru.ispras.ml.classification.passiveaggressive.models.SupportVectorPAModel;
import ru.ispras.ml.classification.passiveaggressive.trainers.SoftMarginPATrainerI;
import ru.ispras.ml.classification.passiveaggressive.trainers.SoftMarginPATrainerII;
import ru.ispras.ml.classification.passiveaggressive.trainers.StandardPATrainer;

public class PABuilder {
    public static <LabelType> PassiveAggressive buildStandard(LabelType positiveLabel, LabelType negativeLabel) {
        LinearPAModel<LabelType> model = new LinearPAModel<LabelType>(positiveLabel, negativeLabel);
        return new PassiveAggressive(new StandardPATrainer(model));
    }

    public static <LabelType> PassiveAggressive buildStandard(LabelType positiveLabel, LabelType negativeLabel, IKernelFunction kernel) {
        SupportVectorPAModel<LabelType> model = new SupportVectorPAModel<LabelType>(positiveLabel, negativeLabel, kernel);
        return new PassiveAggressive(new StandardPATrainer(model));
    }

    public static PassiveAggressive buildStandard(IPAModel model) {
        return new PassiveAggressive(new StandardPATrainer(model));
    }

    public static <LabelType> PassiveAggressive buildSoftMarginI(LabelType positiveLabel, LabelType negativeLabel, double aggressiveness) {
        LinearPAModel<LabelType> model = new LinearPAModel<LabelType>(positiveLabel, negativeLabel);
        return new PassiveAggressive<LabelType>(new SoftMarginPATrainerI<LabelType>(model, aggressiveness));
    }

    public static <LabelType> PassiveAggressive buildSoftMarginI(LabelType positiveLabel, LabelType negativeLabel, IKernelFunction kernel, double aggressiveness) {
        SupportVectorPAModel<LabelType> model = new SupportVectorPAModel<LabelType>(positiveLabel, negativeLabel, kernel);
        return new PassiveAggressive<LabelType>(new SoftMarginPATrainerI<LabelType>(model, aggressiveness));
    }

    public static PassiveAggressive buildSoftMarginI(IPAModel model, double aggressiveness) {
        return new PassiveAggressive(new SoftMarginPATrainerI(model, aggressiveness));
    }

    public static <LabelType> PassiveAggressive buildSoftMarginII(LabelType positiveLabel, LabelType negativeLabel, double aggressiveness) {
        LinearPAModel<LabelType> model = new LinearPAModel<LabelType>(positiveLabel, negativeLabel);
        return new PassiveAggressive<LabelType>(new SoftMarginPATrainerII<LabelType>(model, aggressiveness));
    }

    public static <LabelType> PassiveAggressive buildSoftMarginII(LabelType positiveLabel, LabelType negativeLabel, IKernelFunction kernel, double aggressiveness) {
        SupportVectorPAModel<LabelType> model = new SupportVectorPAModel<LabelType>(positiveLabel, negativeLabel, kernel);
        return new PassiveAggressive<LabelType>(new SoftMarginPATrainerII<LabelType>(model, aggressiveness));
    }

    public static PassiveAggressive buildSoftMarginII(IPAModel model, double aggressiveness) {
        return new PassiveAggressive(new SoftMarginPATrainerII(model, aggressiveness));
    }

    public static <LabelType> PassiveAggressive buildStandard(LabelType positiveLabel, LabelType negativeLabel, double margin) {
        LinearPAModel<LabelType> model = new LinearPAModel<LabelType>(positiveLabel, negativeLabel);
        return new PassiveAggressive<LabelType>(new StandardPATrainer<LabelType>(model, margin), margin);
    }

    public static <LabelType> PassiveAggressive buildStandard(LabelType positiveLabel, LabelType negativeLabel, IKernelFunction kernel, double margin) {
        SupportVectorPAModel<LabelType> model = new SupportVectorPAModel<LabelType>(positiveLabel, negativeLabel, kernel);
        return new PassiveAggressive<LabelType>(new StandardPATrainer<LabelType>(model, margin), margin);
    }

    public static PassiveAggressive buildStandard(IPAModel model, double margin) {
        return new PassiveAggressive(new StandardPATrainer(model, margin), margin);
    }

    public static <LabelType> PassiveAggressive buildSoftMarginI(LabelType positiveLabel, LabelType negativeLabel, double margin, double aggressiveness) {
        LinearPAModel<LabelType> model = new LinearPAModel<LabelType>(positiveLabel, negativeLabel);
        return new PassiveAggressive<LabelType>(new SoftMarginPATrainerI<LabelType>(model, margin, aggressiveness), margin);
    }

    public static <LabelType> PassiveAggressive buildSoftMarginI(LabelType positiveLabel, LabelType negativeLabel, IKernelFunction kernel, double margin, double aggressiveness) {
        SupportVectorPAModel<LabelType> model = new SupportVectorPAModel<LabelType>(positiveLabel, negativeLabel, kernel);
        return new PassiveAggressive<LabelType>(new SoftMarginPATrainerI<LabelType>(model, margin, aggressiveness), margin);
    }

    public static PassiveAggressive buildSoftMarginI(IPAModel model, double margin, double aggressiveness) {
        return new PassiveAggressive(new SoftMarginPATrainerI(model, margin, aggressiveness), margin);
    }

    public static <LabelType> PassiveAggressive buildSoftMarginII(LabelType positiveLabel, LabelType negativeLabel, double margin, double aggressiveness) {
        LinearPAModel<LabelType> model = new LinearPAModel<LabelType>(positiveLabel, negativeLabel);
        return new PassiveAggressive<LabelType>(new SoftMarginPATrainerII<LabelType>(model, margin, aggressiveness), margin);
    }

    public static <LabelType> PassiveAggressive buildSoftMarginII(LabelType positiveLabel, LabelType negativeLabel, IKernelFunction kernel, double margin, double aggressiveness) {
        SupportVectorPAModel<LabelType> model = new SupportVectorPAModel<LabelType>(positiveLabel, negativeLabel, kernel);
        return new PassiveAggressive<LabelType>(new SoftMarginPATrainerII<LabelType>(model, margin, aggressiveness), margin);
    }

    public static PassiveAggressive buildSoftMarginII(IPAModel model, double margin, double aggressiveness) {
        return new PassiveAggressive(new SoftMarginPATrainerII(model, margin, aggressiveness), margin);
    }
}

