/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.classification.naivebayes;

import java.util.stream.Stream;
import ru.ispras.ml.TrainingException;
import ru.ispras.ml.classification.IConfidenceClassifier;
import ru.ispras.ml.classification.IConfidenceClassifierTrainer;
import ru.ispras.ml.classification.naivebayes.NaiveBayesClassifier;
import ru.ispras.ml.classification.naivebayes.NaiveBayesModel;
import ru.ispras.ml.datamodel.ILabeledDataset;
import ru.ispras.ml.datamodel.ILabelledInstance;

public class NaiveBayesTrainer<LabelType>
implements IConfidenceClassifierTrainer<LabelType> {
    private static final long serialVersionUID = -5366633331164560713L;
    private NaiveBayesModel<LabelType> model;

    public NaiveBayesTrainer() {
        this.model = new NaiveBayesModel();
    }

    protected NaiveBayesTrainer(NaiveBayesModel<LabelType> model) {
        this.model = model;
    }

    public NaiveBayesModel<LabelType> getModel() {
        return this.model;
    }

    @Override
    public void train(ILabelledInstance<LabelType> instance) throws TrainingException {
        if (instance == null) {
            throw new TrainingException("Error while training: instance in null");
        }
        this.model.addClassifiedInstance(instance, instance.getLabel());
    }

    @Override
    public void train(ILabeledDataset<LabelType> dataset) throws TrainingException {
        if (dataset == null) {
            throw new TrainingException("Error while training list: instanses is null");
        }
        try (Stream stream = dataset.stream();){
            ((Stream)stream.sequential()).forEach(instance -> this.train((ILabelledInstance<LabelType>)instance));
        }
    }

    @Override
    public IConfidenceClassifier<LabelType> getPredictor() {
        return new NaiveBayesClassifier<LabelType>(this.model);
    }
}

