/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.classification.meta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import ru.ispras.ml.datamodel.IInstance;
import ru.ispras.ml.datamodel.ILabeledDataset;
import ru.ispras.ml.datamodel.ILabelledInstance;
import ru.ispras.ml.datamodel.LabelledInstance;
import ru.ispras.ml.datamodel.ListLabelledDataset;

class ClassifiedInstances<LabelType> {
    private final List<IInstance> instances = new ArrayList<IInstance>();
    private final List<LabelType> classResults = new ArrayList<LabelType>();

    public ClassifiedInstances() {
        this(Collections.emptyList());
    }

    public ClassifiedInstances(Iterable<ILabelledInstance<LabelType>> dataset) {
        for (ILabelledInstance<LabelType> instance : dataset) {
            this.instances.add(instance);
            this.classResults.add(instance.getLabel());
        }
    }

    public ClassifiedInstances(ILabeledDataset<LabelType> dataset) {
        try (Stream stream = dataset.stream();){
            ((Stream)stream.sequential()).forEach(instance -> {
                this.instances.add((IInstance)instance);
                this.classResults.add(instance.getLabel());
            });
        }
    }

    public ListLabelledDataset<LabelType> getLabelledDataset() {
        ArrayList result = new ArrayList();
        for (int i = 0; i < this.instances.size(); ++i) {
            result.add(new LabelledInstance<LabelType>(this.instances.get(i), this.classResults.get(i)));
        }
        return new ListLabelledDataset(result);
    }

    public void add(IInstance instance, LabelType classResult) {
        this.instances.add(instance);
        this.classResults.add(classResult);
    }

    public void add(ClassifiedInstances<LabelType> dataSet) {
        this.instances.addAll(dataSet.getInstances());
        this.classResults.addAll(dataSet.getClassificationResults());
    }

    public List<IInstance> getInstances() {
        return this.instances;
    }

    public List<LabelType> getClassificationResults() {
        return this.classResults;
    }

    public boolean isEmpty() {
        return this.instances.isEmpty();
    }

    public int size() {
        return this.instances.size();
    }

    public IInstance getInstance(int index) {
        this.checkIndex(index);
        return this.instances.get(index);
    }

    public LabelType getClassificationResult(int index) {
        this.checkIndex(index);
        return this.classResults.get(index);
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.instances.size()) {
            throw new IllegalArgumentException("Illegal index: given " + String.valueOf(index) + ", allowed index range: [0, " + String.valueOf(this.instances.size() - 1) + "].");
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.classResults == null ? 0 : this.classResults.hashCode());
        result = 31 * result + (this.instances == null ? 0 : this.instances.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ClassifiedInstances) {
            ClassifiedInstances other = (ClassifiedInstances)obj;
            return other.classResults.equals(this.classResults) && other.instances.equals(this.instances);
        }
        return false;
    }
}

