/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.classification.decisiontrees.id3;

import ru.ispras.ml.classification.decisiontrees.EntropyCounter;
import ru.ispras.ml.classification.decisiontrees.FeatureValuesInSample;
import ru.ispras.ml.classification.decisiontrees.Sample;
import ru.ispras.ml.classification.decisiontrees.SplitSample;
import ru.ispras.ml.classification.decisiontrees.id3.InformationGainMetricCounter;
import ru.ispras.ml.datamodel.Feature;

public class TopInformationGainSampleSplitter {
    public static SplitSample split(Sample sample, FeatureValuesInSample featureSet) {
        double fullEntropy = EntropyCounter.countEntropy(sample.countClassFractions().values(), sample.size());
        SplitSample bestSplit = null;
        double maxGain = 0.0;
        for (Feature feature : featureSet.getFeatures()) {
            SplitSample splitSample = sample.splitByFeature(feature);
            double gain = InformationGainMetricCounter.countGain(splitSample, sample.size(), fullEntropy);
            if (!(gain >= maxGain)) continue;
            maxGain = gain;
            bestSplit = splitSample;
        }
        return bestSplit;
    }
}

