/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.classification.decisiontrees.id3;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import ru.ispras.ml.classification.ClassificationResult;
import ru.ispras.ml.classification.decisiontrees.DecisionTree;
import ru.ispras.ml.classification.decisiontrees.FeatureValuesInSample;
import ru.ispras.ml.classification.decisiontrees.Sample;
import ru.ispras.ml.classification.decisiontrees.SplitSample;
import ru.ispras.ml.classification.decisiontrees.id3.TopInformationGainSampleSplitter;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.value.IValue;

public class ID3TreeBuilder
implements Serializable {
    private static final long serialVersionUID = -6888218935107268L;

    public DecisionTree buildSubtree(Sample sample, FeatureValuesInSample featureSet, ClassificationResult popularInParent) {
        if (sample == null || sample.isEmpty()) {
            return new DecisionTree(popularInParent);
        }
        Map<ClassificationResult, Integer> classRatings = sample.countClassFractions();
        ClassificationResult mostPopularResult = ID3TreeBuilder.findMostPopularClass(classRatings);
        if (classRatings.size() == 1) {
            return new DecisionTree(mostPopularResult);
        }
        if (featureSet.isEmpty()) {
            return new DecisionTree(mostPopularResult);
        }
        return this.buildInnerNode(sample, featureSet, mostPopularResult);
    }

    private DecisionTree buildInnerNode(Sample sample, FeatureValuesInSample featureSet, ClassificationResult mostPopularResult) {
        SplitSample splitSample = TopInformationGainSampleSplitter.split(sample, featureSet);
        Feature splitFeature = splitSample.getFeature();
        Map bestSubsamples = splitSample.getSubsamples();
        FeatureValuesInSample childrenFeatureSet = new FeatureValuesInSample(featureSet);
        childrenFeatureSet.exclude(splitFeature);
        HashMap nodeChildren = new HashMap();
        for (IValue value : featureSet.getValuesForFeature(splitFeature)) {
            Sample sampleForChild = bestSubsamples.get(value);
            nodeChildren.put(value, this.buildSubtree(sampleForChild, childrenFeatureSet, mostPopularResult));
        }
        return new DecisionTree(splitFeature, nodeChildren);
    }

    private static ClassificationResult findMostPopularClass(Map<ClassificationResult, Integer> classRatings) {
        Comparator<Map.Entry<ClassificationResult, Integer>> classRatingComparator = new Comparator<Map.Entry<ClassificationResult, Integer>>(){

            @Override
            public int compare(Map.Entry<ClassificationResult, Integer> o1, Map.Entry<ClassificationResult, Integer> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        };
        Map.Entry<ClassificationResult, Integer> result = Collections.max(classRatings.entrySet(), classRatingComparator);
        return new ClassificationResult<ClassificationResult>(Collections.max(classRatings.entrySet(), classRatingComparator).getKey());
    }
}

