/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.classification.decisiontrees;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.value.IValue;

public class FeatureValuesInSample
implements Serializable {
    private static final long serialVersionUID = 2337245499276806048L;
    private final Map<Feature, Set<IValue>> featureValues;

    public FeatureValuesInSample() {
        this.featureValues = new HashMap<Feature, Set<IValue>>();
    }

    public FeatureValuesInSample(FeatureValuesInSample old) {
        this.featureValues = new HashMap<Feature, Set<IValue>>(old.featureValues);
    }

    public Set<Feature> getFeatures() {
        return this.featureValues.keySet();
    }

    public void exclude(Feature feature) {
        this.featureValues.remove(feature);
    }

    private Set<IValue> getFeatureValues(Feature feature) {
        if (this.featureValues.containsKey(feature)) {
            return this.featureValues.get(feature);
        }
        HashSet<IValue> values = new HashSet<IValue>();
        this.featureValues.put(feature, values);
        return values;
    }

    public void addFeatureValue(Feature feature, IValue value) {
        this.getFeatureValues(feature).add(value);
    }

    public Set<IValue> getValuesForFeature(Feature feature) {
        return this.featureValues.get(feature);
    }

    public boolean isEmpty() {
        return this.featureValues.isEmpty();
    }

    public boolean equals(Object o) {
        if (o instanceof FeatureValuesInSample) {
            FeatureValuesInSample castedObj = (FeatureValuesInSample)o;
            return this.featureValues.equals(castedObj.featureValues);
        }
        return false;
    }
}

