/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.classification.decisiontrees;

import java.util.Collection;

public class EntropyCounter {
    public static final double EPSILON = 1.0E-9;

    public static double countEntropy(Collection<Integer> partition, int totalCount) {
        double result = 0.0;
        for (Integer part : partition) {
            double fraction = (double)part.intValue() / (double)totalCount;
            if (!(fraction >= 1.0E-9)) continue;
            result -= fraction * EntropyCounter.log2(fraction);
        }
        return result;
    }

    private static double log2(double arg) {
        double naturalLogOf2 = Math.log(2.0);
        return Math.log(arg) / naturalLogOf2;
    }
}

