/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.classification.decisiontrees;

import ru.ispras.ml.TrainingException;
import ru.ispras.ml.classification.ClassificationAlgorithmFacade;
import ru.ispras.ml.classification.ClassificationException;
import ru.ispras.ml.classification.ClassificationResult;
import ru.ispras.ml.classification.IClassifier;
import ru.ispras.ml.classification.decisiontrees.DecisionTreeClassifier;
import ru.ispras.ml.classification.decisiontrees.IDecisionTreeTrainer;
import ru.ispras.ml.datamodel.IInstance;
import ru.ispras.ml.datamodel.ILabeledDataset;
import ru.ispras.ml.datamodel.ILabelledInstance;

public class DecisionTreeClassificationAlgorithmFacade<LabelType>
implements ClassificationAlgorithmFacade<LabelType> {
    private static final long serialVersionUID = -6584817139067351024L;
    private final IDecisionTreeTrainer<LabelType> trainer;
    private DecisionTreeClassifier<LabelType> classifier;

    public DecisionTreeClassificationAlgorithmFacade(IDecisionTreeTrainer<LabelType> trainer) {
        this.trainer = trainer;
    }

    @Override
    public void train(ILabelledInstance<LabelType> precedent) throws TrainingException {
        this.trainer.train(precedent);
        this.classifier = new DecisionTreeClassifier(this.trainer.getModel());
    }

    @Override
    public void train(ILabeledDataset<LabelType> precedents) throws TrainingException {
        this.trainer.train(precedents);
        this.classifier = new DecisionTreeClassifier(this.trainer.getModel());
    }

    @Override
    public ClassificationResult<LabelType> predict(IInstance instance) throws ClassificationException {
        return this.classifier.predict(instance);
    }

    @Override
    public IClassifier<LabelType> getPredictor() {
        return this.classifier;
    }
}

