/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.classification.decisiontrees;

import java.io.Serializable;
import java.util.Map;
import ru.ispras.ml.classification.ClassificationResult;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.value.IValue;

public class DecisionTree<LabelType>
implements Serializable {
    static final long serialVersionUID = 238964782345L;
    private Feature feature;
    private Map<IValue, DecisionTree<LabelType>> children;
    private ClassificationResult<LabelType> className;

    public DecisionTree(Feature feature, Map<IValue, DecisionTree<LabelType>> children) {
        this.feature = feature;
        this.children = children;
    }

    public DecisionTree(ClassificationResult<LabelType> className) {
        this.feature = null;
        this.className = className;
    }

    public Feature getFeature() {
        return this.feature;
    }

    public ClassificationResult<LabelType> getClassificationResult() {
        return this.className;
    }

    public DecisionTree getChildForValue(IValue value) {
        return this.children.get(value);
    }

    public boolean equals(Object other) {
        if (other instanceof DecisionTree) {
            DecisionTree tree = (DecisionTree)other;
            if (this.feature != null) {
                return this.feature.equals(tree.feature) && this.children.equals(tree.children);
            }
            return this.className.equals(tree.className);
        }
        return false;
    }
}

