/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.api.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import ru.ispras.texterra.core.configuration.TexterraConfiguration;

public final class PerScopeCache<T> {
    private final Function<String, T> perScopeSupplier;
    private final ConcurrentMap<Optional<String>, T> scopeToValue = new ConcurrentHashMap<Optional<String>, T>();
    private final Lock lock = new ReentrantLock();

    public PerScopeCache(Function<String, T> perScopeSupplier) {
        this.perScopeSupplier = perScopeSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(String scope) {
        Optional<String> key = this.getKey(scope);
        Object value = this.scopeToValue.get(key);
        if (value != null) {
            return (T)value;
        }
        this.lock.lock();
        try {
            value = this.scopeToValue.get(key);
            if (value != null) {
                Object v = value;
                return (T)v;
            }
            value = this.perScopeSupplier.apply(scope);
            this.scopeToValue.put(key, value);
            Object object = value;
            return (T)object;
        }
        finally {
            this.lock.unlock();
        }
    }

    private Optional<String> getKey(String scope) {
        if (Objects.equals(scope, TexterraConfiguration.NO_SCOPE)) {
            return Optional.empty();
        }
        return Optional.of(scope);
    }

    public Collection<T> values() {
        return Collections.unmodifiableCollection(this.scopeToValue.values());
    }
}

