/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.tools.nlp.ne.pipelines.graph.opennlp;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import opennlp.tools.namefind.TokenNameFinderModel;
import ru.ispras.modis.utils.ClasspathUtils;
import ru.ispras.modis.utils.config.validation.ConfigurationProperty;
import ru.ispras.texterra.core.configuration.TexterraConfiguration;
import ru.ispras.texterra.core.configuration.TexterraConfigurationFactory;
import ru.ispras.texterra.core.exceptions.TexterraConfigException;
import ru.ispras.texterra.core.exceptions.TexterraSystemException;
import ru.ispras.texterra.core.nlp.annotators.IAnnotator;
import ru.ispras.texterra.core.nlp.annotators.ne.OpenNLPNETagger;
import ru.ispras.texterra.core.nlp.datamodel.IToken;
import ru.ispras.texterra.core.nlp.datamodel.IValuedAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.Language;
import ru.ispras.texterra.core.nlp.datamodel.Sentence;
import ru.ispras.texterra.core.nlp.datamodel.ne.INamedEntity;
import ru.ispras.texterra.core.nlp.datamodel.ne.NamedEntityToken;
import ru.ispras.texterra.tools.nlp.datamodel.NLPDocumentOptions;
import ru.ispras.texterra.tools.nlp.modelsio.AbstractOptionsBasedModelsIO;
import ru.ispras.texterra.tools.nlp.pipelines.graph.IPipelineNodeProvider;
import ru.ispras.texterra.tools.nlp.pipelines.graph.PipelineNode;
import ru.ispras.texterra.tools.nlp.pipelines.graph.PipelineNodeDependencies;

public final class PersistentOpenNLPNameFinderProvider
implements IPipelineNodeProvider<NamedEntityToken, OpenNLPNETagger>,
Serializable {
    private static final long serialVersionUID = -8988008525756635371L;
    @ConfigurationProperty
    private static final String modelNameProperty = "modelName";
    private static final Pattern scopePattern = Pattern.compile("([^\\#]+)\\#(.+)");
    private final Map<INamedEntity, ModelsIO> entityToModelsIO;

    public PersistentOpenNLPNameFinderProvider(INamedEntity ... entities) {
        this(Arrays.asList(entities));
    }

    public PersistentOpenNLPNameFinderProvider(Collection<? extends INamedEntity> entities) {
        TexterraConfiguration config = TexterraConfigurationFactory.getConfiguration();
        Map<INamedEntity, String> entityToScope = this.getEntityToScope(config, entities);
        this.entityToModelsIO = this.getEntityToModelsIO(config, entityToScope);
    }

    private Map<INamedEntity, String> getEntityToScope(TexterraConfiguration config, Collection<? extends INamedEntity> entities) {
        HashMap<INamedEntity, String> entityToScope = new HashMap<INamedEntity, String>();
        if (entities.isEmpty()) {
            Set scopes = config.getScopes(PersistentOpenNLPNameFinderProvider.class);
            for (String scope : scopes) {
                entityToScope.put(this.toEntity(scope), scope);
            }
        } else {
            for (INamedEntity iNamedEntity : entities) {
                entityToScope.put(iNamedEntity, this.toScope(iNamedEntity));
            }
        }
        return entityToScope;
    }

    private INamedEntity toEntity(String scope) {
        Matcher matcher = scopePattern.matcher(scope);
        if (!matcher.find()) {
            throw new TexterraConfigException(PersistentOpenNLPNameFinderProvider.class, modelNameProperty, String.format("Scope should be in format <enum class name>#<constant name>, given: %s.", scope));
        }
        String typeName = matcher.group(1);
        String constantName = matcher.group(2);
        try {
            Class<INamedEntity> type = Class.forName(typeName).asSubclass(INamedEntity.class);
            if (!type.isEnum()) {
                throw new TexterraConfigException(PersistentOpenNLPNameFinderProvider.class, modelNameProperty, String.format("Scope should refer to enum type, given: %s.", typeName));
            }
            Method valueOfMethod = type.getDeclaredMethod("valueOf", String.class);
            return (INamedEntity)valueOfMethod.invoke(type, constantName);
        }
        catch (ClassNotFoundException e) {
            throw new TexterraConfigException(PersistentOpenNLPNameFinderProvider.class, modelNameProperty, String.format("Scope should refer to existing class name, given: %s.", typeName));
        }
        catch (ClassCastException e) {
            throw new TexterraConfigException(PersistentOpenNLPNameFinderProvider.class, modelNameProperty, String.format("Scope should refer to subclass of INamedEntity, given: %s.", typeName));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new TexterraConfigException(PersistentOpenNLPNameFinderProvider.class, modelNameProperty, String.format("%s enum doesn't have %s contant.", typeName, constantName));
        }
    }

    private String toScope(INamedEntity entity) {
        if (!entity.getClass().isEnum()) {
            throw new TexterraSystemException(String.format("%s is not a enum constant.", entity));
        }
        return String.format("%s#%s", entity.getClass().getName(), entity);
    }

    private Map<INamedEntity, ModelsIO> getEntityToModelsIO(TexterraConfiguration config, Map<INamedEntity, String> entityToScope) {
        HashMap<INamedEntity, ModelsIO> entityToModelsIO = new HashMap<INamedEntity, ModelsIO>();
        for (Map.Entry<INamedEntity, String> entry : entityToScope.entrySet()) {
            INamedEntity entity = entry.getKey();
            String scope = entry.getValue();
            String modelName = config.getStringProperty(PersistentOpenNLPNameFinderProvider.class, modelNameProperty, scope);
            entityToModelsIO.put(entity, new ModelsIO(modelName));
        }
        return entityToModelsIO;
    }

    public PipelineNode<NamedEntityToken, OpenNLPNETagger> get(NLPDocumentOptions options) {
        return new PipelineNode(new PipelineNodeDependencies().withSoftImplicitDependencies(new Class[]{Sentence.class, IToken.class}), (IAnnotator)new OpenNLPNETagger(this.getModels(options)));
    }

    private Map<INamedEntity, TokenNameFinderModel> getModels(NLPDocumentOptions options) {
        HashMap<INamedEntity, TokenNameFinderModel> models = new HashMap<INamedEntity, TokenNameFinderModel>();
        for (Map.Entry<INamedEntity, ModelsIO> entry : this.entityToModelsIO.entrySet()) {
            models.put(entry.getKey(), entry.getValue().load(options));
        }
        return models;
    }

    public Set<Class<? extends IValuedAnnotation<?>>> getRequiredOptions() {
        return Collections.singleton(Language.class);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.entityToModelsIO.keySet().hashCode();
        result = 31 * result + this.getClass().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PersistentOpenNLPNameFinderProvider other = (PersistentOpenNLPNameFinderProvider)obj;
        return this.entityToModelsIO.keySet().equals(other.entityToModelsIO.keySet());
    }

    private static final class ModelsIO
    extends AbstractOptionsBasedModelsIO<TokenNameFinderModel>
    implements Serializable {
        private static final long serialVersionUID = -225444116332833818L;
        private final String modelName;

        public ModelsIO(String modelName) {
            this.modelName = modelName;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public TokenNameFinderModel load(NLPDocumentOptions options) {
            String modelsPath = this.getModelsPath(options);
            try (InputStream in = ClasspathUtils.getResourceAsStream((String)modelsPath, (String)this.modelName);){
                TokenNameFinderModel tokenNameFinderModel = new TokenNameFinderModel(in);
                return tokenNameFinderModel;
            }
            catch (IOException e) {
                throw new TexterraConfigException("Can't load model for OpenNLP NameFinder", (Throwable)e);
            }
        }

        public void save(NLPDocumentOptions options, TokenNameFinderModel model) {
            throw new UnsupportedOperationException("Saving of OpenNLP NameFinder model is not implemented.");
        }
    }
}

