/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.tools.nlp.ne.factories;

import java.io.Serializable;
import ru.ispras.texterra.core.nlp.datamodel.FastInRelationNLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.IToken;
import ru.ispras.texterra.core.nlp.datamodel.Lemma;
import ru.ispras.texterra.core.nlp.datamodel.Sentence;
import ru.ispras.texterra.core.nlp.datamodel.ne.encoding.NamedEntityEncodingToken;
import ru.ispras.texterra.core.nlp.datamodel.pos.POSToken;
import ru.ispras.texterra.core.nlp.datamodel.relations.CoinsidesAnnotationRelationCacheBuilder;
import ru.ispras.texterra.core.nlp.datamodel.relations.ContainedAnnotationRelationCacheBuilder;
import ru.ispras.texterra.core.nlp.datamodel.relations.ContainsAnnotationRelationCacheBuilder;
import ru.ispras.texterra.core.nlp.datamodel.relations.IAnnotationRelationCacheBuilder;
import ru.ispras.texterra.core.nlp.factories.DefaultDocumentFactory;
import ru.ispras.texterra.core.nlp.factories.IDocumentFactory;

public final class NERCDocumentFactory
implements IDocumentFactory,
Serializable {
    private static final long serialVersionUID = -3650457264880860465L;
    private static final ContainedAnnotationRelationCacheBuilder CONTAINED_CACHE_BUILDER = new ContainedAnnotationRelationCacheBuilder();
    private static final CoinsidesAnnotationRelationCacheBuilder COINSIDES_CACHE_BUILDER = new CoinsidesAnnotationRelationCacheBuilder();
    private static final ContainsAnnotationRelationCacheBuilder CONTAINS_CACHE_BUILDER = new ContainsAnnotationRelationCacheBuilder();
    private final IDocumentFactory wrapped = new DefaultDocumentFactory();

    public INLPDocument create(String text) {
        INLPDocument doc = this.wrapped.create(text);
        doc = this.wrapFastSentenceTokens(doc);
        doc = this.wrapFastTokenSentence(doc);
        doc = this.wrapFastTokenPOSToken(doc);
        doc = this.wrapFastTokenLemma(doc);
        doc = this.wrapFastTokenNamedEntityEncodingToken(doc);
        return doc;
    }

    private INLPDocument wrapFastSentenceTokens(INLPDocument doc) {
        return new FastInRelationNLPDocument(doc, Sentence.class, IToken.class, (IAnnotationRelationCacheBuilder)CONTAINS_CACHE_BUILDER);
    }

    private INLPDocument wrapFastTokenSentence(INLPDocument doc) {
        return new FastInRelationNLPDocument(doc, IToken.class, Sentence.class, (IAnnotationRelationCacheBuilder)CONTAINED_CACHE_BUILDER);
    }

    private INLPDocument wrapFastTokenPOSToken(INLPDocument doc) {
        return new FastInRelationNLPDocument(doc, IToken.class, POSToken.class, (IAnnotationRelationCacheBuilder)COINSIDES_CACHE_BUILDER);
    }

    private INLPDocument wrapFastTokenLemma(INLPDocument doc) {
        return new FastInRelationNLPDocument(doc, IToken.class, Lemma.class, (IAnnotationRelationCacheBuilder)COINSIDES_CACHE_BUILDER);
    }

    private INLPDocument wrapFastTokenNamedEntityEncodingToken(INLPDocument doc) {
        return new FastInRelationNLPDocument(doc, IToken.class, NamedEntityEncodingToken.class, (IAnnotationRelationCacheBuilder)COINSIDES_CACHE_BUILDER);
    }
}

