/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.weka.regression;

import java.util.ArrayList;
import java.util.List;
import ru.ispras.ml.TrainingException;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.IInstance;
import ru.ispras.ml.datamodel.ILabeledDataset;
import ru.ispras.ml.datamodel.ListLabelledDataset;
import ru.ispras.ml.regression.IRegressor;
import ru.ispras.ml.weka.AbstractWekaPredictorTrainer;
import ru.ispras.ml.weka.WekaAdapterUtils;
import ru.ispras.ml.weka.regression.WekaRegressorAdapter;
import weka.classifiers.Classifier;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class WekaRegressorTrainer
extends AbstractWekaPredictorTrainer<Double, WekaRegressorAdapter> {
    private static final long serialVersionUID = -5780447380943998159L;
    private static final String CLASS_ATTRIBUTE_NAME = "regressionValue";

    public WekaRegressorTrainer(Classifier wekaPredictor) {
        super(wekaPredictor);
    }

    @Override
    public void train(ILabeledDataset<Double> data) throws TrainingException {
        ListLabelledDataset<Double> precedents = new ListLabelledDataset<Double>(data);
        if (precedents.isEmpty()) {
            throw new IllegalArgumentException();
        }
        ArrayList<Feature> uniqueFeatures = new ArrayList<Feature>(precedents.getFeatureSet());
        FastVector wekaAttributes = WekaRegressorTrainer.createWekaAttributes(uniqueFeatures);
        Instances trainingSet = this.createWekaDataset(precedents, uniqueFeatures, wekaAttributes);
        this.trainWekaPredictor(trainingSet);
        this.wekaAdapter = new WekaRegressorAdapter(this.wekaPredictor, wekaAttributes, trainingSet, uniqueFeatures);
    }

    private static FastVector createWekaAttributes(List<Feature> features) {
        FastVector wekaAttributes = WekaRegressorTrainer.createAttributesForFeatures(features);
        wekaAttributes.addElement((Object)new Attribute(CLASS_ATTRIBUTE_NAME));
        return wekaAttributes;
    }

    @Override
    protected Instance toWekaInstance(IInstance instance, Double correctAnswer, FastVector wekaAttributes, List<Feature> uniqueFeatures) {
        Instance wekaInstance = WekaAdapterUtils.toUnlabeledWekaInstance(instance, wekaAttributes, uniqueFeatures);
        wekaInstance.setValue((Attribute)wekaAttributes.lastElement(), correctAnswer.doubleValue());
        return wekaInstance;
    }

    public IRegressor getPredictor() {
        return (IRegressor)this.getWekaAdapter();
    }
}

