/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.weka.regression;

import java.util.List;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.IInstance;
import ru.ispras.ml.regression.IRegressor;
import ru.ispras.ml.regression.RegressionException;
import ru.ispras.ml.regression.RegressionResult;
import ru.ispras.ml.weka.AbstractWekaPredictorAdapter;
import ru.ispras.ml.weka.WekaAdapterUtils;
import weka.classifiers.Classifier;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class WekaRegressorAdapter
extends AbstractWekaPredictorAdapter
implements IRegressor {
    private static final long serialVersionUID = 8048487049120203311L;

    public WekaRegressorAdapter(Classifier wekaRegressor, FastVector wekaAttributes, Instances trainingSet, List<Feature> orderedFeatures) {
        super(wekaRegressor, wekaAttributes, trainingSet, orderedFeatures);
    }

    @Override
    public RegressionResult predict(IInstance instance) throws RegressionException {
        Instance wekaInstance = WekaAdapterUtils.toUnlabeledWekaInstance(instance, this.wekaAttributes, this.orderedFeatures);
        wekaInstance.setDataset(this.trainingSet);
        try {
            double wekaRegressionResult = this.wekaPredictor.classifyInstance(wekaInstance);
            return new RegressionResult(wekaRegressionResult);
        }
        catch (Exception e) {
            throw new RegressionException(e);
        }
    }
}

