/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.ml.weka.classification;

import java.util.ArrayList;
import java.util.List;
import ru.ispras.ml.TrainingException;
import ru.ispras.ml.classification.IClassifier;
import ru.ispras.ml.classification.IClassifierTrainer;
import ru.ispras.ml.datamodel.Feature;
import ru.ispras.ml.datamodel.IInstance;
import ru.ispras.ml.datamodel.ILabeledDataset;
import ru.ispras.ml.datamodel.ListLabelledDataset;
import ru.ispras.ml.weka.AbstractWekaPredictorTrainer;
import ru.ispras.ml.weka.WekaAdapterUtils;
import ru.ispras.ml.weka.classification.WekaClassifierAdapter;
import weka.classifiers.Classifier;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class WekaClassifierTrainer<LabelType>
extends AbstractWekaPredictorTrainer<LabelType, WekaClassifierAdapter<LabelType>>
implements IClassifierTrainer<LabelType> {
    private static final long serialVersionUID = -2798326357812774949L;
    private static final String CLASS_ATTRIBUTE_NAME = "classId";

    public WekaClassifierTrainer(Classifier wekaPredictor) {
        super(wekaPredictor);
    }

    @Override
    public void train(ILabeledDataset<LabelType> data) throws TrainingException {
        ListLabelledDataset<LabelType> precedents = new ListLabelledDataset<LabelType>(data);
        if (precedents.isEmpty()) {
            throw new IllegalArgumentException();
        }
        ArrayList uniqueClasses = new ArrayList(precedents.getLabelsSet());
        ArrayList<Feature> uniqueFeatures = new ArrayList<Feature>(precedents.getFeatureSet());
        FastVector wekaAttributes = WekaClassifierTrainer.createWekaAttributes(uniqueClasses, uniqueFeatures);
        Instances trainingSet = this.createWekaDataset(precedents, uniqueFeatures, wekaAttributes);
        this.trainWekaPredictor(trainingSet);
        this.wekaAdapter = new WekaClassifierAdapter(this.wekaPredictor, wekaAttributes, trainingSet, uniqueFeatures, uniqueClasses);
    }

    private static <LabelType> FastVector createWekaAttributes(List<LabelType> classes, List<Feature> features) {
        FastVector wekaAttributes = WekaClassifierTrainer.createAttributesForFeatures(features);
        WekaClassifierTrainer.addAttributeForNominalClass(classes, wekaAttributes);
        return wekaAttributes;
    }

    private static <LabelType> void addAttributeForNominalClass(List<LabelType> classes, FastVector wekaAttributes) {
        FastVector classVal = new FastVector(classes.size());
        for (LabelType classId : classes) {
            classVal.addElement(classId);
        }
        wekaAttributes.addElement((Object)new Attribute(CLASS_ATTRIBUTE_NAME, classVal));
    }

    @Override
    protected Instance toWekaInstance(IInstance instance, LabelType correctAnswer, FastVector wekaAttributes, List<Feature> uniqueFeatures) {
        Instance wekaInstance = WekaAdapterUtils.toUnlabeledWekaInstance(instance, wekaAttributes, uniqueFeatures);
        wekaInstance.setValue((Attribute)wekaAttributes.lastElement(), correctAnswer.toString());
        return wekaInstance;
    }

    @Override
    public IClassifier<LabelType> getPredictor() {
        return (IClassifier)this.getWekaAdapter();
    }
}

